/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.lexer;

import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.classfile.attributes.DGCode;
import com.wily.diagnos.personality.java.classfile.attributes.DGExceptionsAttribute;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGFieldMethodRefConstant;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.parser.Token;
import com.wily.introscope.probebuilder.intelligent.instrumentation.parser.TokenManager;
import com.wily.introscope.probebuilder.lexer.LexerUtils;
import com.wily.introscope.probebuilder.scoring.MethodScorer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Map;
import java.util.Set;

public class ByteCodeLexer
implements TokenManager {
    private static final String kTypeUnIdentifiedMsg = "Unable to identify type";
    private byte[] fMethodByteCode;
    private DGCode fDgCode;
    private int fPC = -1;
    private Map<String, Object> fDecisionParameters;
    private IModuleFeedbackChannel fLog;
    private StringBuffer fTokenStream = new StringBuffer();
    private int fInstrumentationDecisionThreshold = 100;
    private boolean fFullParseEnabled;
    private Module fModule;

    public ByteCodeLexer(Map<String, Object> decisionParameters) {
        this.fDecisionParameters = decisionParameters;
        this.fModule = IntelligentInstrumentationConfig.INSTANCE.getIntelligentInstrumentationModule();
        this.fLog = IntelligentInstrumentationConfig.INSTANCE.getModuleFeedbackChannel();
        this.setFullParseEnabled();
    }

    protected void setFullParseEnabled() {
        this.fFullParseEnabled = IntelligentInstrumentationConfig.INSTANCE.isFullParseEnabled();
    }

    public void reinit(DGCode dgCode) {
        this.fDgCode = dgCode;
        this.fMethodByteCode = dgCode.getCodeBytes();
        this.fPC = -1;
        this.fTokenStream = new StringBuffer();
        this.fInstrumentationDecisionThreshold = this.getDecisionThreshold();
    }

    protected int getDecisionThreshold() {
        return IntelligentInstrumentationConfig.INSTANCE.getInstrumentationDecisionThreshold();
    }

    @Override
    public Token getNextToken() {
        this.compareScores();
        Token currentToken = null;
        while (currentToken == null) {
            if (!this.isDecided()) {
                if (this.fPC == -1) {
                    ++this.fPC;
                    currentToken = LexerUtils.createToken(1);
                    this.identifyModifiers(currentToken);
                    this.identifyThrowsException(currentToken);
                    continue;
                }
                if (this.fPC < this.fMethodByteCode.length) {
                    int base = this.fPC;
                    int nextOpCode = ByteCodeLexer.readUnsignedByte(this.fMethodByteCode, this.fPC);
                    ++this.fPC;
                    switch (nextOpCode) {
                        case 182: 
                        case 183: 
                        case 184: {
                            currentToken = LexerUtils.createToken(this.getMethodCallType());
                            this.fPC += 2;
                            break;
                        }
                        case 185: 
                        case 186: {
                            currentToken = LexerUtils.createToken(this.getMethodCallType());
                            this.fPC += 4;
                            break;
                        }
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: {
                            int currentLine = this.fPC - 1;
                            int jumpTarget = ByteCodeLexer.getJumpTarget(this.fMethodByteCode, base, this.fPC);
                            String image = LexerUtils.getBranchImage(currentLine, jumpTarget);
                            int ofKind = jumpTarget < currentLine ? 22 : 18;
                            currentToken = Token.newToken(ofKind, image);
                            this.fPC += 2;
                            break;
                        }
                        case 167: {
                            int currentLine = this.fPC - 1;
                            int jumpTarget = ByteCodeLexer.getJumpTarget(this.fMethodByteCode, base, this.fPC);
                            String image = LexerUtils.getBranchImage(currentLine, jumpTarget);
                            int ofKind = jumpTarget < currentLine ? 23 : 19;
                            currentToken = Token.newToken(ofKind, image);
                            this.fPC += 2;
                            break;
                        }
                        case 171: {
                            int caseCount = this.getCaseCountAndSkipLookupSwitchOps();
                            currentToken = Token.newToken(16, Integer.toString(caseCount));
                            break;
                        }
                        case 170: {
                            int caseCount = this.getCaseCountAndSkipTableSwitchOps();
                            currentToken = Token.newToken(16, Integer.toString(caseCount));
                            break;
                        }
                        case 16: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: 
                        case 209: {
                            ++this.fPC;
                            break;
                        }
                        case 168: 
                        case 198: 
                        case 199: 
                        case 210: {
                            this.fPC += 2;
                            break;
                        }
                        case 200: 
                        case 201: 
                        case 212: {
                            this.fPC += 4;
                            break;
                        }
                        case 18: {
                            ++this.fPC;
                            break;
                        }
                        case 17: 
                        case 19: 
                        case 20: 
                        case 132: 
                        case 178: 
                        case 179: 
                        case 180: 
                        case 181: 
                        case 187: 
                        case 189: 
                        case 192: 
                        case 193: {
                            this.fPC += 2;
                            break;
                        }
                        case 197: {
                            this.fPC += 3;
                            break;
                        }
                        case 194: {
                            currentToken = LexerUtils.createToken(20);
                            break;
                        }
                        case 195: {
                            if (!this.considerMonitorExit(this.fPC - 1)) break;
                            currentToken = LexerUtils.createToken(21);
                            break;
                        }
                        case 196: {
                            int nextop = ByteCodeLexer.readUnsignedByte(this.fMethodByteCode, this.fPC);
                            ++this.fPC;
                            if (nextop == 132) {
                                this.fPC += 4;
                                break;
                            }
                            this.fPC += 2;
                            break;
                        }
                        case 191: {
                            currentToken = Token.newToken(15, kTypeUnIdentifiedMsg);
                            break;
                        }
                    }
                    continue;
                }
                int caughtExceptionCount = this.countCaughtExceptions();
                if (caughtExceptionCount > 0) {
                    currentToken = Token.newToken(17, Integer.toString(caughtExceptionCount));
                    Token tobeAdded = LexerUtils.createToken(2);
                    ByteCodeLexer.addToken(currentToken, tobeAdded);
                    continue;
                }
                currentToken = LexerUtils.createToken(2);
                continue;
            }
            currentToken = LexerUtils.createToken(0);
        }
        if (this.fLog.isDebugEnabled(this.fModule)) {
            LexerUtils.genTokenNameAndImageStream(currentToken, this.fTokenStream);
        }
        return currentToken;
    }

    protected void compareScores() {
        MethodScorer scorer = (MethodScorer)this.fDecisionParameters.get("METHOD_SCORE");
        if (scorer.getCurrentScore() >= this.fInstrumentationDecisionThreshold) {
            this.fDecisionParameters.put("DECISION_MADE", true);
            this.fDecisionParameters.put("INSTRUMENTATION_DECISION", true);
        }
    }

    private int countCaughtExceptions() {
        DGCode.DGExceptionEntry[] entries;
        int count = 0;
        for (DGCode.DGExceptionEntry entry : entries = this.fDgCode.getExceptionTable()) {
            int typeIndex = entry.getCatchTypeCPI();
            if (typeIndex == 0) continue;
            ++count;
        }
        return count;
    }

    private boolean considerMonitorExit(int pcValue) {
        DGCode.DGExceptionEntry[] entries;
        for (DGCode.DGExceptionEntry entry : entries = this.fDgCode.getExceptionTable()) {
            if (pcValue < entry.getStartPC() || pcValue > entry.getEndPC() || entry.getStartPC() != entry.getHandlerPC()) continue;
            return true;
        }
        return false;
    }

    public String getTokenStream() {
        return this.fTokenStream.toString();
    }

    public String getMethodArtifacts() {
        return LexerUtils.combineMethodArtifacts(this.fDgCode.getMethod().getDGClass().getClassName().getPackageAndNameString(), this.fDgCode.getMethod().getName(), this.fDgCode.getMethod().getSignature().toString());
    }

    private void identifyModifiers(Token currentToken) {
        Token tobeAdded;
        int accessFlags = this.fDgCode.getMethod().getAccessFlags();
        if ((accessFlags & 1) != 0) {
            tobeAdded = LexerUtils.createToken(3);
            ByteCodeLexer.addToken(currentToken, tobeAdded);
        }
        if ((accessFlags & 2) != 0) {
            tobeAdded = LexerUtils.createToken(4);
            ByteCodeLexer.addToken(currentToken, tobeAdded);
        }
        if ((accessFlags & 0x20) != 0) {
            tobeAdded = LexerUtils.createToken(6);
            ByteCodeLexer.addToken(currentToken, tobeAdded);
        }
        if ((accessFlags & 8) != 0) {
            tobeAdded = LexerUtils.createToken(5);
            ByteCodeLexer.addToken(currentToken, tobeAdded);
        }
    }

    private void identifyThrowsException(Token currentToken) {
        DGExceptionsAttribute exceptionAttr = this.fDgCode.getMethod().getExceptions();
        if (exceptionAttr != null) {
            String[] exceptionTypes;
            for (String exceptionType : exceptionTypes = exceptionAttr.getExceptionTypes()) {
                Token exceptionToken = Token.newToken(7, exceptionType);
                ByteCodeLexer.addToken(currentToken, exceptionToken);
            }
        }
    }

    private String getTypeForThrownException(int throwProgConter) {
        String exceptionType = null;
        if (throwProgConter < 4) {
            return exceptionType;
        }
        int reversedIndex = throwProgConter - 4;
        int nextOpCode = ByteCodeLexer.readUnsignedByte(this.fMethodByteCode, reversedIndex);
        ++reversedIndex;
        if (nextOpCode == 183 || nextOpCode == 180 || nextOpCode == 178) {
            int cpi = this.readUnsignedShort(reversedIndex);
            DGConstant dgConstant = this.fDgCode.getConstantPool().getConstant(cpi);
            if (dgConstant instanceof DGFieldMethodRefConstant) {
                DGFieldMethodRefConstant method = (DGFieldMethodRefConstant)dgConstant;
                if (nextOpCode == 180 || nextOpCode == 178) {
                    String type = method.getType();
                    exceptionType = type.substring(1, type.length() - 1);
                } else {
                    exceptionType = method.getClassName();
                }
                return exceptionType;
            }
        }
        return exceptionType;
    }

    private int getMethodCallType() {
        int cpi = this.readUnsignedShort(this.fPC);
        DGConstant dgConstant = null;
        int kind = 8;
        DGMethod dgMethod = this.fDgCode.getMethod();
        String method = LexerUtils.combineMethodArtifacts(dgMethod.getDGClass().getClassName().getPackageAndNameString(), dgMethod.getName(), dgMethod.getSignature().toString());
        dgConstant = this.fDgCode.getConstantPool().getConstant(cpi);
        if (dgConstant instanceof DGFieldMethodRefConstant) {
            DGFieldMethodRefConstant methodConstant = (DGFieldMethodRefConstant)dgConstant;
            String calledMethod = LexerUtils.combineMethodArtifacts(methodConstant.getClassName(), methodConstant.getName(), methodConstant.getType());
            Set strings = (Set)IntelligentInstrumentationConfig.INSTANCE.getUninterestingPrefixes().getValue();
            kind = LexerUtils.getMethodCallKind(calledMethod, method, strings);
        }
        return kind;
    }

    protected boolean isDecided() {
        return this.fDecisionParameters.get("DECISION_MADE").equals(Boolean.TRUE) && !this.fFullParseEnabled;
    }

    private static int readUnsignedByte(byte[] classByteCode, int pc) {
        return classByteCode[pc] & 0xFF;
    }

    private int getCaseCountAndSkipLookupSwitchOps() {
        byte arg4;
        byte arg3;
        byte arg2;
        byte arg1;
        int numPairs;
        while (this.fPC % 4 != 0) {
            ++this.fPC;
        }
        this.fPC += 4;
        if ((numPairs = DGCode.signedIntToInt((byte)(arg1 = this.fMethodByteCode[this.fPC++]), (byte)(arg2 = this.fMethodByteCode[this.fPC++]), (byte)(arg3 = this.fMethodByteCode[this.fPC++]), (byte)(arg4 = this.fMethodByteCode[this.fPC++]))) >= 0) {
            this.fPC += numPairs * 8;
        }
        return numPairs;
    }

    private int getCaseCountAndSkipTableSwitchOps() {
        while (this.fPC % 4 != 0) {
            ++this.fPC;
        }
        this.fPC += 4;
        byte arg1 = this.fMethodByteCode[this.fPC++];
        byte arg2 = this.fMethodByteCode[this.fPC++];
        byte arg3 = this.fMethodByteCode[this.fPC++];
        byte arg4 = this.fMethodByteCode[this.fPC++];
        int lowByte = DGCode.signedIntToInt((byte)arg1, (byte)arg2, (byte)arg3, (byte)arg4);
        arg1 = this.fMethodByteCode[this.fPC++];
        arg2 = this.fMethodByteCode[this.fPC++];
        arg3 = this.fMethodByteCode[this.fPC++];
        arg4 = this.fMethodByteCode[this.fPC++];
        int highByte = DGCode.signedIntToInt((byte)arg1, (byte)arg2, (byte)arg3, (byte)arg4);
        int caseCount = highByte - lowByte + 1;
        this.fPC += caseCount * 4;
        return caseCount;
    }

    private static int getJumpTarget(byte[] byteCode, int base, int pc) {
        byte arg1 = byteCode[pc];
        byte arg2 = byteCode[pc + 1];
        return base + DGCode.signedShortToInt((byte)arg1, (byte)arg2);
    }

    private static void addToken(Token head, Token tobeAdded) {
        Token temp = head;
        while (temp.next != null) {
            temp = temp.next;
        }
        temp.next = tobeAdded;
    }

    private int readUnsignedShort(int pc) {
        int nextShort = this.fMethodByteCode[pc];
        nextShort = nextShort << 8 | ByteCodeLexer.readUnsignedByte(this.fMethodByteCode, pc + 1);
        return nextShort & 0xFFFF;
    }

    public void setLogger(IModuleFeedbackChannel logger) {
        this.fLog = logger;
    }
}

