/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.tracer;

import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;

public final class MethodTracer {
    public static final MethodTracer[] kZeroLengthArray = new MethodTracer[0];
    private static final String kAggregator = "customAggregator";
    private final TracerGroup fTracerGroup;
    private final IClassName fInstrumentationClass;
    private final IClassMatcher fClassMatcher;
    private final IMethodMatcher fMethodMatcher;
    private final String fTracerParameters;
    private final boolean fNeedsParameterAccess;
    private final IClassName fTracerClass;
    private final int fTracerOrdering;
    private final String fFileName;
    private final int fLine;
    private final TracerName fTracerName;
    private final String fTracerResource;
    private final boolean fIsNewBlame;
    private final boolean fIsDeclaredOldBlame;
    private final boolean fIsMaybeOldBlame;
    private boolean fNeedsStubbing;
    private boolean fOptionalRunning;

    public MethodTracer(String fileName, int line, IClassName instrumentationClass, TracerGroup tracerGroup, IClassMatcher classMatcher, IMethodMatcher methodMatcher, String tracerParameters, boolean needsParameterAccess, IClassName tracerClass, int tracerOrdering) {
        this(fileName, line, instrumentationClass, tracerGroup, classMatcher, methodMatcher, tracerParameters, needsParameterAccess, tracerClass, tracerOrdering, null, null, false, false, true, false, false);
    }

    public MethodTracer(String fileName, int line, IClassName instrumentationClass, TracerGroup tracerGroup, IClassMatcher classMatcher, IMethodMatcher methodMatcher, String tracerParameters, boolean needsParameterAccess, IClassName tracerClass, int tracerOrdering, TracerName tracerName, String tracerResource, boolean isNewBlame, boolean isDeclaredOldBlame, boolean isMaybeOldBlame, boolean needsStubbing, boolean optionalRunning) {
        this.fInstrumentationClass = instrumentationClass;
        this.fTracerGroup = tracerGroup;
        this.fIsMaybeOldBlame = isMaybeOldBlame;
        this.fClassMatcher = classMatcher.IClassMatcher_generateImmutableMatcher();
        this.fMethodMatcher = methodMatcher;
        this.fTracerParameters = tracerParameters;
        this.fNeedsParameterAccess = needsParameterAccess;
        this.fTracerClass = tracerClass;
        this.fTracerOrdering = tracerOrdering;
        this.fLine = line;
        this.fFileName = fileName;
        this.fTracerName = tracerName;
        this.fTracerResource = tracerResource;
        this.fIsNewBlame = isNewBlame;
        this.fIsDeclaredOldBlame = isDeclaredOldBlame;
        this.fNeedsStubbing = needsStubbing;
        this.fOptionalRunning = optionalRunning;
    }

    protected final IClassName getInstrumentationClass() {
        return this.fInstrumentationClass;
    }

    public final TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public final IClassMatcher getClassMatcher() {
        return this.fClassMatcher;
    }

    public final IMethodMatcher getMethodMatcher() {
        return this.fMethodMatcher;
    }

    public final String getTracerParameters() {
        return this.fTracerParameters;
    }

    public final boolean needsParameterAccess() {
        return this.fNeedsParameterAccess;
    }

    public final IClassName getTracerClass() {
        return this.fTracerClass;
    }

    public final int getTracerOrdering() {
        return this.fTracerOrdering;
    }

    public final TracerName getTracerName() {
        return this.fTracerName;
    }

    public final String getTracerResource() {
        return this.fTracerResource;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fClassMatcher);
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fInstrumentationClass);
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fMethodMatcher);
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fTracerClass);
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fTracerGroup);
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fTracerOrdering);
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fTracerParameters);
        return result;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof MethodTracer) {
            MethodTracer otherMT = (MethodTracer)other;
            return this.safeEquals(otherMT.fTracerParameters, this.fTracerParameters) && otherMT.fTracerOrdering == this.fTracerOrdering && this.safeEquals(otherMT.fClassMatcher, this.fClassMatcher) && this.safeEquals(otherMT.fInstrumentationClass, this.fInstrumentationClass) && this.safeEquals(otherMT.fMethodMatcher, this.fMethodMatcher) && this.safeEquals(otherMT.fTracerClass, this.fTracerClass) && this.safeEquals(otherMT.fTracerGroup, this.fTracerGroup);
        }
        return false;
    }

    private boolean safeEquals(Object a, Object b) {
        return a != null ? (b != null ? a.equals(b) : false) : b == null;
    }

    public String getInfo() {
        return this.fFileName + "; line: " + this.fLine;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public int getLine() {
        return this.fLine;
    }

    public String[] getTracerKeys() {
        return this.fClassMatcher != null ? this.fClassMatcher.getMatcherKeys() : IClassMatcher.kAllKeys;
    }

    public final boolean isNewBlame() {
        return this.fIsNewBlame;
    }

    public boolean isDeclaredOldBlame() {
        return this.fIsDeclaredOldBlame;
    }

    public boolean isMaybeOldBlame() {
        return this.fIsMaybeOldBlame;
    }

    public String hasCustomAggregator() {
        int i = this.fTracerParameters.indexOf(kAggregator);
        if (i >= 0) {
            int j = this.fTracerParameters.indexOf("&", i = this.fTracerParameters.indexOf("=", i));
            if (j < 0) {
                return this.fTracerParameters.substring(i + 1);
            }
            return this.fTracerParameters.substring(i + 1, j);
        }
        return null;
    }

    public boolean needsStubbing() {
        return this.fNeedsStubbing;
    }
}

