/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.personality.java.classfile.attributes.stackmapframe.DGVerificationTypeInfoArray;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class DGStackMapFrame {
    private int fOffsetDelta;
    private int fOffset;

    public DGStackMapFrame(int offset, int delta) {
        this.fOffset = offset;
        this.fOffsetDelta = delta;
    }

    public DGStackMapFrame(int prevOffset) {
        this.fOffset = prevOffset > 0 ? prevOffset + 1 : 0;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffsetDelta(int fOffsetDelta) {
        this.fOffsetDelta = fOffsetDelta;
        this.fOffset += fOffsetDelta;
    }

    public int getOffsetDelta() {
        return this.fOffsetDelta;
    }

    public int updateOffset(int prevOffset) {
        this.fOffset = prevOffset + this.fOffsetDelta;
        if (prevOffset > 0) {
            ++this.fOffset;
        }
        return this.fOffset;
    }

    public DGStackMapFrame addToOffsetDelta(int offsetToAdd) {
        this.fOffsetDelta += offsetToAdd;
        this.fOffset += offsetToAdd;
        return this;
    }

    public String toString() {
        return "StackMapFrame";
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract int size();

    protected abstract DGVerificationTypeInfoArray adjustLocals(DGVerificationTypeInfoArray var1);

    protected abstract DGVerificationTypeInfoArray adjustStack(DGVerificationTypeInfoArray var1);

    protected abstract boolean updateUninitializedTypeOffset(int var1, int var2);

    public boolean updateTypeOffsets(int pc, int delta) {
        return this.updateUninitializedTypeOffset(pc, delta);
    }
}

