/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.ejb;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.trace.ejb.EJBHomeWrapper;
import com.wily.introscope.agent.trace.ejb.EJBMetaDataWrapper;
import com.wily.introscope.agent.trace.ejb.EJBObjectWrapper;
import com.wily.introscope.agent.trace.ejb.EntityContextWrapper;
import com.wily.introscope.agent.trace.ejb.MessageDrivenContextWrapper;
import com.wily.introscope.agent.trace.ejb.SessionContextWrapper;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EjbObjectFactory {
    private Map fInterfaceCache = new HashMap();
    private ThreadLocal fInterfaceThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private ClassLoader fClassLoader;
    private static Map sInterfaceCaches = new HashMap();
    private static ThreadLocal sThreadLocalInterfaceCaches = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public EjbObjectFactory(ClassLoader classloader) {
        Assertion.wilyAssert(false);
        this.fClassLoader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbObjectFactory getEjbObjectFactory(Object ejbObject) {
        ClassLoader classLoader = ejbObject.getClass().getClassLoader();
        Map threadLocalCache = (Map)sThreadLocalInterfaceCaches.get();
        EjbObjectFactory cache = (EjbObjectFactory)threadLocalCache.get(classLoader);
        if (cache == null) {
            Map map = sInterfaceCaches;
            synchronized (map) {
                cache = (EjbObjectFactory)sInterfaceCaches.get(classLoader);
                if (cache == null) {
                    cache = new EjbObjectFactory(classLoader);
                    sInterfaceCaches.put(classLoader, cache);
                }
            }
            threadLocalCache.put(classLoader, cache);
        }
        return cache;
    }

    public EJBObjectWrapper getEJBObjectWrapper(Object ejbObject) throws ClassNotFoundException {
        if (!this.verifyInterface(ejbObject.getClass(), "javax.ejb.EJBObject")) {
            return null;
        }
        return new EJBObjectWrapper(this, ejbObject);
    }

    public EJBHomeWrapper getEJBHomeWrapper(Object ejbHome) throws ClassNotFoundException {
        if (!this.verifyInterface(ejbHome.getClass(), "javax.ejb.EJBHome")) {
            return null;
        }
        return new EJBHomeWrapper(this, ejbHome);
    }

    public EJBMetaDataWrapper getEJBMetaDataWrapper(Object ejbMetaData) throws ClassNotFoundException {
        if (!this.verifyInterface(ejbMetaData.getClass(), "javax.ejb.EJBMetaData")) {
            return null;
        }
        return new EJBMetaDataWrapper(this, ejbMetaData);
    }

    public SessionContextWrapper getSessionContextWrapper(Object sessionContext) throws ClassNotFoundException {
        if (!this.verifyInterface(sessionContext.getClass(), "javax.ejb.SessionContext")) {
            return null;
        }
        return new SessionContextWrapper(this, sessionContext);
    }

    public EntityContextWrapper getEntityContextWrapper(Object entityContext) throws ClassNotFoundException {
        if (!this.verifyInterface(entityContext.getClass(), "javax.ejb.EntityContext")) {
            return null;
        }
        return new EntityContextWrapper(this, entityContext);
    }

    public MessageDrivenContextWrapper getMessageDrivenContextWrapper(Object messageDrivenContext) throws ClassNotFoundException {
        if (!this.verifyInterface(messageDrivenContext.getClass(), "javax.ejb.MessageDrivenContext")) {
            return null;
        }
        return new MessageDrivenContextWrapper(this, messageDrivenContext);
    }

    public boolean verifyInterface(Class clazz, String interfaceName) {
        if (clazz == null) {
            return false;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(interfaceName)) continue;
            return true;
        }
        boolean result = this.verifyInterface(clazz.getSuperclass(), interfaceName);
        if (result) {
            return true;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.verifyInterface(interfaces[i], interfaceName)) continue;
            return true;
        }
        return false;
    }

    Class getInterface(String interfaceName) throws ClassNotFoundException {
        MethodCache cache = this.getInterfaceMethodCache(interfaceName);
        if (cache == null) {
            throw new ClassNotFoundException();
        }
        return cache.fClazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodCache getInterfaceMethodCache(String interfaceName) throws ClassNotFoundException {
        Map threadLocalCache = (Map)this.fInterfaceThreadLocal.get();
        MethodCache result = (MethodCache)threadLocalCache.get(interfaceName);
        if (result == null) {
            Map map = this.fInterfaceCache;
            synchronized (map) {
                result = (MethodCache)this.fInterfaceCache.get(interfaceName);
                if (result == null) {
                    try {
                        Class<?> clazz = Class.forName(interfaceName, true, this.fClassLoader);
                        result = new MethodCache(clazz);
                    }
                    catch (ClassNotFoundException ex) {
                        AgentShim.handleError(this.fClassLoader + " can find " + interfaceName, ex);
                        throw ex;
                    }
                    this.fInterfaceCache.put(interfaceName, result);
                }
            }
            threadLocalCache.put(interfaceName, result);
        }
        return result;
    }

    public Method getInterfaceMethod(String interfaceClassName, String methodName, Class[] parameterClasses) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        MethodCache methodCache = this.getInterfaceMethodCache(interfaceClassName);
        Method method = methodCache.getMethod(methodName, parameterClasses);
        return method;
    }

    private static class MethodKey {
        private final String fMethodName;
        private final Class[] fParameterClasses;

        public MethodKey(String name, Class[] classes) {
            this.fMethodName = name;
            this.fParameterClasses = classes;
        }

        public boolean equals(Object obj) {
            MethodKey other = (MethodKey)obj;
            return this.fMethodName == other.fMethodName && Arrays.equals(this.fParameterClasses, other.fParameterClasses);
        }

        public int hashCode() {
            return this.fMethodName.hashCode();
        }
    }

    private static class MethodCache {
        private final Class fClazz;
        private final Map fMethods;
        private ThreadLocal fThreadLocalCache = new ThreadLocal();

        public MethodCache(Class clazz) {
            this.fClazz = clazz;
            this.fMethods = new HashMap();
            this.fThreadLocalCache = new ThreadLocal(){

                protected Object initialValue() {
                    return new HashMap();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Method getMethod(String methodName, Class[] parameterClasses) throws SecurityException, NoSuchMethodException {
            MethodKey key = new MethodKey(methodName, parameterClasses);
            Map threadLocalCache = (Map)this.fThreadLocalCache.get();
            Method method = (Method)threadLocalCache.get(key);
            if (method == null) {
                Map map = this.fMethods;
                synchronized (map) {
                    method = (Method)this.fMethods.get(key);
                    if (method == null) {
                        method = this.fClazz.getMethod(methodName, parameterClasses);
                        this.fMethods.put(key, method);
                    }
                }
                threadLocalCache.put(key, method);
            }
            return method;
        }
    }
}

