/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.patternDef;

import com.wily.introscope.agent.bizdef.BizDefEncapsulatedPattern;
import com.wily.introscope.agent.bizdef.IBizOperationType;
import com.wily.introscope.agent.bizdef.IBizParameter;
import com.wily.introscope.agent.bizdef.IBizParameterSet;
import com.wily.introscope.agent.bizdef.IBizParameterType;
import com.wily.introscope.agent.bizdef.IBizRulePattern;
import com.wily.introscope.agent.bizdef.adt.CaseSensitiveMap;
import com.wily.introscope.agent.bizdef.operations.BizNameExistsOperation;
import com.wily.introscope.agent.bizdef.operations.BizNameNotExistsOperation;
import com.wily.introscope.agent.bizdef.operations.BizNotEqualOperation;
import com.wily.introscope.agent.bizdef.operations.BizRegexNameMatchOperation;
import com.wily.introscope.agent.bizdef.operations.BizRegexValueMatchOperation;
import com.wily.introscope.agent.bizdef.operations.BizSimpleMatchValueOperation;
import com.wily.introscope.agent.bizdef.operations.BizUndefinedOperation;
import com.wily.introscope.agent.bizdef.operations.IBizAction;
import com.wily.introscope.agent.bizdef.operations.IBizNameType;
import java.io.UnsupportedEncodingException;
import java.util.List;

public final class BizHttpRulePattern
implements IBizRulePattern {
    private String cachedStringValue;
    private long fId = this.toString().hashCode();
    private BizDefEncapsulatedPattern fName;
    private IBizParameterType fType;
    private BizDefEncapsulatedPattern fPattern;
    private IBizOperationType fAction;
    private IBizAction fActionOperation;
    private boolean fIsNotExistNameOperation;
    private IBizOperationType fNameType;
    private IBizNameType fNameTypeOperation;
    private boolean fIsBizRegexNameMatchOperation;
    private boolean fCaseSensitiveValue;
    private boolean fCaseSensitiveName;

    public BizHttpRulePattern() {
        this(null, null, null, null, null, true, true);
    }

    public BizHttpRulePattern(String name, IBizParameterType type, String pattern, IBizOperationType action, IBizOperationType nameType) {
        this(name, type, pattern, action, nameType, true, true);
    }

    public BizHttpRulePattern(String name, IBizParameterType type, String pattern, IBizOperationType action, IBizOperationType nameType, boolean caseSensitiveName, boolean caseSensitiveValue) {
        this.fName = new BizDefEncapsulatedPattern(name);
        this.fType = type;
        this.fPattern = new BizDefEncapsulatedPattern(pattern);
        this.fAction = action;
        this.fActionOperation = this.getActionOperation(this.fAction);
        this.fIsNotExistNameOperation = this.fActionOperation instanceof BizNameNotExistsOperation;
        this.fNameType = nameType;
        this.fNameTypeOperation = this.getNameTypeOperation(this.fNameType);
        this.fIsBizRegexNameMatchOperation = this.fNameTypeOperation instanceof BizRegexNameMatchOperation;
        this.fCaseSensitiveName = caseSensitiveName;
        this.fCaseSensitiveValue = caseSensitiveValue;
        this.cachedStringValue = this.toString();
    }

    @Override
    public long getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName.getPattern();
    }

    @Override
    public void setName(String name) {
        this.fName = new BizDefEncapsulatedPattern(name);
        this.cachedStringValue = this.toString();
    }

    @Override
    public IBizParameterType getType() {
        return this.fType;
    }

    @Override
    public void setType(IBizParameterType type) {
        this.fType = type;
        this.cachedStringValue = this.toString();
    }

    @Override
    public String getPattern() {
        return this.fPattern.getPattern();
    }

    @Override
    public void setPattern(String pattern) {
        this.fPattern = new BizDefEncapsulatedPattern(pattern);
        this.cachedStringValue = this.toString();
    }

    @Override
    public IBizOperationType getAction() {
        return this.fAction;
    }

    @Override
    public void setAction(IBizOperationType action) {
        this.fAction = action;
        this.cachedStringValue = this.toString();
    }

    @Override
    public IBizOperationType getNameType() {
        return this.fNameType;
    }

    @Override
    public void setNameType(IBizOperationType nameType) {
        this.fNameType = nameType;
        this.cachedStringValue = this.toString();
    }

    @Override
    public boolean getCaseSensitiveName() {
        return this.fCaseSensitiveName;
    }

    @Override
    public boolean getCaseSensitiveValue() {
        return this.fCaseSensitiveValue;
    }

    public IBizAction getActionOperation(IBizOperationType type) {
        if (type.equals("SIMPLE_MATCH_VALUE_OPERATION")) {
            return new BizSimpleMatchValueOperation(type);
        }
        if (type.equals("NAME_NOT_EXISTS_OPERATION")) {
            return new BizNameNotExistsOperation(type);
        }
        if (type.equals("NOT_EQUALS_OPERATION")) {
            return new BizNotEqualOperation(type);
        }
        if (type.equals("REGEX_VALUE_OPERATION")) {
            return new BizRegexValueMatchOperation(type);
        }
        if (type.equals("UNDEFINED_OPERATION")) {
            return new BizUndefinedOperation(type);
        }
        return new BizSimpleMatchValueOperation(type);
    }

    public IBizNameType getNameTypeOperation(IBizOperationType type) {
        if (type.equals("LITERAL_NAME_OPERATION")) {
            return new BizNameExistsOperation(type);
        }
        if (type.equals("REGEX_NAME_OPERATION")) {
            return new BizRegexNameMatchOperation(type);
        }
        if (type.equals("UNDEFINED_OPERATION")) {
            return new BizUndefinedOperation(type);
        }
        return new BizNameExistsOperation(type);
    }

    public final boolean matches(IBizParameterSet bizParameterSet) throws UnsupportedEncodingException {
        IBizParameter bizParameter = bizParameterSet.get(this.fType);
        if (bizParameter == null) {
            return this.fIsNotExistNameOperation;
        }
        if (bizParameter.getValue() != null) {
            return this.workWithSingleParameter(bizParameter);
        }
        CaseSensitiveMap parameterMap = bizParameter.getValues();
        List parameters = this.getParameterMatchingNameOperation(parameterMap);
        if (this.fIsNotExistNameOperation) {
            return parameters == null;
        }
        if (parameters == null) {
            return false;
        }
        for (Object parameter : parameters) {
            if (!this.fActionOperation.matches(parameter, this.fName, this.fPattern, parameterMap, this.fCaseSensitiveName, this.fCaseSensitiveValue)) continue;
            return true;
        }
        return false;
    }

    private List getParameterMatchingNameOperation(CaseSensitiveMap parameterMap) {
        return this.fNameTypeOperation.matches(this.fName, parameterMap, this.fCaseSensitiveName, this.fCaseSensitiveValue);
    }

    private boolean workWithSingleParameter(IBizParameter bizParameter) {
        if (bizParameter.getName() == null) {
            return false;
        }
        if (this.fType.equals("PATH") || this.fType.equals("HOST") || this.fType.equals("PORT")) {
            return this.fActionOperation.matches(this.fPattern, bizParameter.getValue(), this.fCaseSensitiveValue);
        }
        return false;
    }

    public int getLength() {
        int length = 0;
        if (this.fName != null) {
            length += this.fName.toString().length();
        }
        if (this.fType != null) {
            length += this.fType.toString().length();
        }
        if (this.fPattern != null) {
            length += this.fPattern.toString().length();
        }
        if (this.fAction != null) {
            length += this.fAction.toString().length();
        }
        return length;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("");
        if (this.fName != null) {
            buffer.append("Pattern Name = ");
            buffer.append(this.fName.toString());
            buffer.append(",");
        }
        if (this.fPattern != null) {
            buffer.append("Pattern Value = ");
            buffer.append(this.fPattern.toString());
            buffer.append(",");
        }
        if (this.fType != null) {
            buffer.append("Pattern Type =");
            buffer.append(this.fType.toString());
            buffer.append(",");
        }
        if (this.fNameType != null) {
            buffer.append("Pattern NameType Operation = ");
            buffer.append(this.fNameType.toString());
            buffer.append(",");
        }
        if (this.fAction != null) {
            buffer.append("Pattern Action Operation = ");
            buffer.append(this.fAction.toString());
            buffer.append(",");
        }
        buffer.append("Pattern Case Sensitive Name = ");
        buffer.append(this.fCaseSensitiveName);
        buffer.append(",Pattern Case Sensitive Value = ");
        buffer.append(this.fCaseSensitiveValue);
        return buffer.toString();
    }

    public int hashCode() {
        return this.cachedStringValue.hashCode();
    }

    public boolean equals(Object arg0) {
        return this.cachedStringValue.equals(arg0);
    }
}

