/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.jmxclient.transformers.compositedata;

import com.ca.agent.jmxclient.transformers.compositedata.CommittedValue;
import com.ca.agent.jmxclient.transformers.compositedata.UsedValue;
import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;

public class UsedCommittedPercentageValue<T extends CompositeDataSupport>
implements MetricValueTransformer<T, Number> {
    private final UsedValue used = new UsedValue();
    private final CommittedValue committed = new CommittedValue();

    @Override
    public Number transform(T value, Map info) {
        long usedMem = this.used.transform(value, info).longValue();
        long comMem = this.committed.transform(value, info).longValue();
        if (comMem <= 0L || usedMem > comMem) {
            return -1;
        }
        Double p = (double)usedMem * 100.0 / (double)comMem + 0.5;
        return p.longValue();
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof CompositeDataSupport;
    }
}

