/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.IntroscopeProtocolAdaptor;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.util.feedback.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SpringBootEndpointDataView
extends AJMXDataView {
    private static final Module sModule = new Module("JMXService");
    Map<String, AJMXDataView> viewsMap;
    private String objectName;

    protected SpringBootEndpointDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, Map<String, AJMXDataView> viewsMap) {
        super(agent, on, server, attributeName, null);
        this.viewsMap = viewsMap;
        this.objectName = on.getCanonicalName();
    }

    @Override
    public String getFullMetricName() {
        return this.objectName;
    }

    @Override
    protected void doDestroy() {
        if (this.viewsMap != null && this.viewsMap.size() > 0) {
            Iterator<AJMXDataView> it = this.viewsMap.values().iterator();
            while (it.hasNext()) {
                it.next().doDestroy();
            }
        }
    }

    @Override
    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return null;
    }

    @Override
    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        long failedPollCount = 0L;
        long successfulPollCount = 0L;
        if (currentValue != null) {
            JsonElement objectValue = null;
            JsonParser parser = new JsonParser();
            JsonElement ele = null;
            Map<String, AJMXDataView> views = this.getViewsMap();
            if (currentValue instanceof ArrayList) {
                ArrayList attValueList = (ArrayList)currentValue;
                for (int i = 0; i < attValueList.size(); ++i) {
                    String inputString = attValueList.get(i).toString();
                    String threadName = inputString.substring(1, inputString.indexOf(","));
                    String json = inputString.replace(threadName + ",", "");
                    json = json.replace("#", "_");
                    if (IntroscopeProtocolAdaptor.fJmxSpringbootThreadsList == null || !IntroscopeProtocolAdaptor.fJmxSpringbootThreadsList.contains(threadName.split("=")[1])) continue;
                    for (String s : IntroscopeProtocolAdaptor.fJmxSpringbootThreadsFilterCharList) {
                        threadName = threadName.replace(s, "_");
                    }
                    try {
                        ele = parser.parse(json.trim());
                        if (!ele.isJsonObject()) continue;
                        JsonObject obj = ele.getAsJsonObject();
                        Set<Map.Entry<String, JsonElement>> entries = obj.entrySet();
                        for (Map.Entry<String, JsonElement> entry : entries) {
                            if (!views.containsKey(threadName + entry.getKey())) continue;
                            objectValue = entry.getValue();
                            if (objectValue != null) {
                                views.get(threadName + entry.getKey()).doUpdate(objectValue);
                                ++successfulPollCount;
                                continue;
                            }
                            this.debugTrace(sModule, "Can't find matching object Value for Attribute key - " + this.getAttKey());
                            ++failedPollCount;
                        }
                        continue;
                    }
                    catch (JsonParseException e) {
                        this.debugTrace(sModule, "Parse exception while polling data  - Threadname - " + threadName + " Json - " + json);
                    }
                }
            } else if (currentValue instanceof LinkedHashMap) {
                LinkedHashMap map = (LinkedHashMap)currentValue;
                for (Object o : map.keySet()) {
                    if (!views.containsKey(o)) continue;
                    objectValue = (JsonElement)map.get(o);
                    if (objectValue != null) {
                        views.get(o).doUpdate(objectValue);
                        ++successfulPollCount;
                        continue;
                    }
                    this.debugTrace(sModule, "Can't find matching object Value for Attribute key - " + this.getAttKey());
                    ++failedPollCount;
                }
            }
            this.addSuccessfulPollCount(successfulPollCount - 1L);
            this.addCurrentFailedPollCount(failedPollCount);
        }
    }

    public Map<String, AJMXDataView> getViewsMap() {
        return this.viewsMap;
    }

    public void setViewsMap(HashMap<String, AJMXDataView> viewsMap) {
        this.viewsMap = viewsMap;
    }

    public int getViewSize() {
        return this.viewsMap.size();
    }
}

