/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.webappsupport;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IAgentService;
import java.util.Map;

public abstract class AWebAppSupportReflectionDelegatingService
implements IAgentService {
    private final String fDelegateServiceName;
    private final String fDelegateClassName;
    private final ClassLoader fDelegateClassLoader;

    protected AWebAppSupportReflectionDelegatingService(String delegateName, String delegateClassName, ClassLoader delegateClassLoader) {
        this.fDelegateServiceName = delegateName;
        this.fDelegateClassName = delegateClassName;
        this.fDelegateClassLoader = delegateClassLoader;
    }

    private final String getDelegateServiceName() {
        return this.fDelegateServiceName;
    }

    private final String getDelegateServiceClassName() {
        return this.fDelegateClassName;
    }

    private final ClassLoader getDelegateServiceClassLoader() {
        return this.fDelegateClassLoader;
    }

    public final int IAgentService_getServiceVersion() {
        return 2;
    }

    public final void IAgentService_startService(IAgent agent, Map parameters) throws Exception {
        long startDelayInSeconds = agent.IAgent_getIndexedProperties().getLongProperty("introscope.agent.webappsupport.startDelayInSeconds", 5L);
        if (startDelayInSeconds < 5L) {
            startDelayInSeconds = 5L;
        }
        agent.IAgent_getModuleFeedback().info("Will start " + this.getDelegateServiceName() + " WebAppSupport in " + startDelayInSeconds + " seconds");
        try {
            Thread.sleep(startDelayInSeconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        agent.IAgent_getModuleFeedback().info("Starting " + this.getDelegateServiceName() + " WebAppSupport with parameters: " + parameters);
        if (this.environmentProbeAllowsDelegateLoad(agent)) {
            try {
                agent.IAgent_getServiceAdministrator().registerServiceSync(agent, this.getDelegateServiceName(), this.getDelegateServiceClassName(), this.getDelegateServiceClassLoader(), parameters);
            }
            catch (Throwable t) {
                this.handleInvocationException(agent, t);
            }
        }
    }

    private final boolean environmentProbeAllowsDelegateLoad(IAgent agent) {
        return this.doShouldAttemptDelegateLoad(agent);
    }

    private final void handleInvocationException(IAgent agent, Throwable t) {
        this.doHandleDelegateLoadException(agent, t);
    }

    protected abstract boolean doShouldAttemptDelegateLoad(IAgent var1);

    protected abstract void doHandleDelegateLoadException(IAgent var1, Throwable var2);
}

