/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.probe.net.ManagedSocket;
import com.wily.introscope.agent.probe.net.ServerSocketMonitor;
import com.wily.introscope.agent.probe.net.SocketMonitor;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

public class ManagedServerSocket
extends ServerSocket {
    private static final String kIsClosedMethod = "isClosed";
    private static final boolean sIsJavaOneFourOrHigher = ManagedServerSocket.isJavaOneFourOrHigher();
    private ServerSocketMonitor fMonitor = null;

    private static synchronized boolean isJavaOneFourOrHigher() {
        try {
            Class<?> parent = Class.forName("java.net.ServerSocket");
            parent.getDeclaredMethod(kIsClosedMethod, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException nsme) {}
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            return false;
        }
    }

    public ManagedServerSocket(int port) throws IOException {
        super(port);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ManagedServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ManagedServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ManagedServerSocket() throws IOException {
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        super.bind(endpoint);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        super.bind(endpoint, backlog);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isServerSocketTraced() {
        int port = this.getLocalPort();
        if (port == -1) {
            return false;
        }
        boolean traced = TracedSockets.isTraced(port);
        if (!traced) {
            traced = TracedSockets.add(port);
        }
        return traced;
    }

    private final void com_wily_initialize() {
        try {
            ServerSocketMonitor monitor;
            if (this.fMonitor == null && this.isServerSocketTraced() && (monitor = SocketMonitor.getServerSocketMonitor(this.getLocalPort())) != null) {
                monitor.eventOpen();
                this.fMonitor = monitor;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception initializing server socket", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            ServerSocketMonitor monitor = this.fMonitor;
            if (monitor != null) {
                this.fMonitor.eventClose();
                this.fMonitor = null;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception tracking a server socket close", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Socket accept() throws IOException {
        if (sIsJavaOneFourOrHigher) {
            return this.com_wily_accept14();
        }
        return this.com_wily_accept12();
    }

    private final Socket com_wily_accept12() throws IOException {
        ServerSocketMonitor monitor;
        Socket socket = null;
        try {
            monitor = this.fMonitor;
            if (monitor != null) {
                socket = new ManagedSocket(monitor);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable td) {
            // empty catch block
        }
        if (socket != null) {
            this.implAccept(socket);
        } else {
            socket = super.accept();
        }
        try {
            monitor = this.fMonitor;
            if (monitor != null) {
                monitor.eventAccept();
            }
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return socket;
    }

    private final Socket com_wily_accept14() throws IOException {
        ServerSocketMonitor monitor;
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        Socket socket = null;
        try {
            monitor = this.fMonitor;
            if (monitor != null) {
                socket = new ManagedSocket(monitor, null);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable td) {
            // empty catch block
        }
        if (socket != null) {
            this.implAccept(socket);
        } else {
            socket = super.accept();
        }
        try {
            monitor = this.fMonitor;
            if (monitor != null) {
                monitor.eventAccept();
            }
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return socket;
    }
}

