/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.nio.SelectorOpenWatcher;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class SocketAcceptMappingTracer
extends ABundledTracerFactory
implements ITracer {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public SocketAcceptMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof ServerSocketChannel) {
            if (!SelectorOpenWatcher.isInSelectorOpen()) {
                return this;
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: instrumented object is not a ServerSocketChannel");
        }
        return null;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return;
        }
        if (!data.hasMethodResultAvailable()) {
            Assertion.wilyAssert("Instrumentation error: no method result");
            return;
        }
        Object resultObject = data.getInvocationReturnValueAsObject();
        if (resultObject == null) {
            return;
        }
        if (!(resultObject instanceof SocketChannel)) {
            Assertion.wilyAssert("Instrumentation error: method result is not a SocketChannel");
            return;
        }
        SocketChannel channel = (SocketChannel)resultObject;
        ServerSocketChannel serverChannel = (ServerSocketChannel)data.getInvocationObject();
        InetSocketAddress localAddress = new InetSocketAddress(serverChannel.socket().getLocalPort());
        SocketChannelMap.put(serverChannel, this.getNameParameter(), localAddress, false);
        SocketChannelMap.put(channel, this.getNameParameter(), localAddress, false);
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public static boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }
}

