/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.stream;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.stream.IMessageStream;
import com.wily.isengard.messageprimitives.stream.MessageStreamSubscriber;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;

public class RegisteredMessageStreamSubscriber
extends MessageStreamSubscriber {
    public RegisteredMessageStreamSubscriber(PostOffice po) {
        super(po);
    }

    public void subscribeTo(String serviceName, IMessageStream callHandler) throws EntryNotFoundException, ConnectionException {
        this.subscribeTo(this.getAddress(serviceName), callHandler);
    }

    private Address getAddress(String serviceName) throws EntryNotFoundException, ConnectionException {
        RegistryEntry entry;
        IRegistryService client = this.getPostOffice().getRegistry();
        try {
            entry = serviceName.charAt(0) != '/' ? client.getEntry(new DirectoryPath("/stream/" + serviceName)) : client.getEntry(new DirectoryPath("/stream" + serviceName));
        }
        catch (InvalidPathException ipe) {
            throw new EntryNotFoundException(ipe.getPath());
        }
        return entry.getAddress();
    }
}

