/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.wily.introscope.agent.extension.deployer.DeploymentManager;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;
import org.kamranzafar.jtar.TarOutputStream;

public class JTarCompressionUtils {
    private static Module kModule = null;
    private static IModuleFeedbackChannel fFeedback = null;
    private static Map<String, ChecksumCacheEntry> fChecksumCache = new CheckSumCache<String, ChecksumCacheEntry>();

    public static void setFeedback(Module module, IModuleFeedbackChannel feedback) {
        kModule = module;
        fFeedback = feedback;
    }

    private static void copyFileToStream(File file, TarOutputStream out) throws IOException {
        int count;
        BufferedInputStream origin = new BufferedInputStream(new FileInputStream(file));
        byte[] data = new byte[2048];
        while ((count = origin.read(data)) != -1) {
            out.write(data, 0, count);
        }
        origin.close();
    }

    private static void copyStreamToFile(TarInputStream in, File file) throws IOException {
        int count;
        byte[] data = new byte[2048];
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream dest = new BufferedOutputStream(fos);
        while ((count = in.read(data)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
    }

    private static void tarDirectory(File root, File directory, TarOutputStream out) throws IOException {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                JTarCompressionUtils.tarDirectory(root, file, out);
                continue;
            }
            String name = file.getAbsolutePath().replace(root.getAbsolutePath() + File.separator, "");
            if (name.equals(".deployment")) continue;
            TarEntry entry = new TarEntry(file, name);
            out.putNextEntry(entry);
            JTarCompressionUtils.copyFileToStream(file, out);
            out.flush();
        }
    }

    public static void tar(ExtendedFile tarFile, ExtendedFile directory) {
        block2: {
            try {
                FileOutputStream inputStream = new FileOutputStream(tarFile.getFile());
                TarOutputStream out = new TarOutputStream(inputStream);
                JTarCompressionUtils.tarDirectory(directory.getFile(), directory.getFile(), out);
                out.close();
            }
            catch (IOException e) {
                fFeedback.error(kModule, "Cannot create the tar file " + tarFile.getAbsolutePath() + " : " + e.getMessage());
                if (!fFeedback.isDebugEnabled(kModule)) break block2;
                fFeedback.debug(kModule, "Cannot create the tar file: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unTar(ExtendedFile tarFile, ExtendedFile directory, boolean deleteSource) {
        boolean result = true;
        FilterInputStream in = null;
        try {
            FileInputStream inputStream = new FileInputStream(tarFile.getFile());
            in = new TarInputStream(inputStream);
            TarEntry entry = ((TarInputStream)in).getNextEntry();
            while (entry != null) {
                File parent;
                if (entry.isDirectory()) {
                    File curdir = new File(directory.getFile(), entry.getName());
                    parent = curdir.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    curdir.mkdirs();
                    entry = ((TarInputStream)in).getNextEntry();
                    continue;
                }
                File curfile = new File(directory.getFile(), entry.getName());
                parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                JTarCompressionUtils.copyStreamToFile((TarInputStream)in, curfile);
                entry = ((TarInputStream)in).getNextEntry();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            result = false;
            DeploymentManager.fDeploymentFailed = true;
            fFeedback.error(kModule, "Cannot untar the file " + tarFile.getAbsolutePath() + " : " + e.getMessage());
            if (fFeedback.isDebugEnabled(kModule)) {
                fFeedback.debug(kModule, "Cannot untar: ", (Throwable)e);
            }
        }
        catch (IOException e) {
            result = false;
            DeploymentManager.fDeploymentFailed = true;
            fFeedback.error(kModule, "Cannot untar the file " + tarFile.getAbsolutePath() + " : " + e.getMessage());
            if (fFeedback.isDebugEnabled(kModule)) {
                fFeedback.debug(kModule, "Cannot untar: ", (Throwable)e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (deleteSource) {
                    tarFile.deleteFile();
                }
            }
            catch (IOException e) {
                fFeedback.debug(kModule, "Cannot delete temporary tar file: ", (Throwable)e);
            }
        }
        return result;
    }

    public static void compress(ExtendedFile src, ExtendedFile dest, boolean deleteSource) {
        block7: {
            try {
                FileInputStream fin = new FileInputStream(src.getFile());
                BufferedInputStream in = new BufferedInputStream(fin);
                FileOutputStream out = new FileOutputStream(dest.getFile());
                GZIPOutputStream gzOut = new GZIPOutputStream(out);
                byte[] buffer = new byte[1024];
                int n = 0;
                while (-1 != (n = in.read(buffer))) {
                    gzOut.write(buffer, 0, n);
                }
                in.close();
                gzOut.close();
                if (deleteSource) {
                    src.deleteFile();
                }
            }
            catch (FileNotFoundException e) {
                if (fFeedback != null) {
                    fFeedback.error(kModule, "Cannot compress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                    if (fFeedback.isDebugEnabled(kModule)) {
                        fFeedback.debug(kModule, "Cannot compress: ", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                if (fFeedback == null) break block7;
                fFeedback.error(kModule, "Cannot compress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                if (!fFeedback.isDebugEnabled(kModule)) break block7;
                fFeedback.debug(kModule, "Cannot compress: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uncompress(ExtendedFile src, ExtendedFile dest) {
        boolean result = true;
        FileOutputStream out = null;
        GZIPInputStream gzIn = null;
        try {
            FileInputStream fin = new FileInputStream(src.getFile());
            BufferedInputStream in = new BufferedInputStream(fin);
            out = new FileOutputStream(dest.getFile());
            gzIn = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int n = 0;
            while (-1 != (n = gzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        catch (FileNotFoundException e) {
            result = false;
            DeploymentManager.fDeploymentFailed = true;
            if (fFeedback != null) {
                fFeedback.error(kModule, "Cannot uncompress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                if (fFeedback.isDebugEnabled(kModule)) {
                    fFeedback.debug(kModule, "Cannot uncompress: ", (Throwable)e);
                }
            }
            if (dest.exists()) {
                try {
                    dest.deleteFile();
                }
                catch (IOException e1) {
                    fFeedback.debug(kModule, "Cannot remove temporary tar file: ", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            result = false;
            DeploymentManager.fDeploymentFailed = true;
            if (fFeedback != null) {
                fFeedback.error(kModule, "Cannot uncompress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                if (fFeedback.isDebugEnabled(kModule)) {
                    fFeedback.debug(kModule, "Cannot uncompress: ", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            if (dest.exists()) {
                try {
                    dest.deleteFile();
                }
                catch (IOException e1) {
                    fFeedback.debug(kModule, "Cannot remove temporary tar file: ", (Throwable)e);
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (gzIn != null) {
                try {
                    gzIn.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    static byte[] createChecksum(ExtendedFile file) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(file.getFile());
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static synchronized String getMD5Checksum(ExtendedFile file) {
        String name = file.getAbsolutePath();
        ChecksumCacheEntry entry = fChecksumCache.get(name);
        if (entry != null && entry.timeStamp == file.getFile().lastModified()) {
            return entry.checksum;
        }
        try {
            if (fFeedback.isDebugEnabled(kModule)) {
                fFeedback.debug(kModule, "Checksum cache size is " + fChecksumCache.size());
                fFeedback.debug(kModule, "Calculating checksum for : " + name);
            }
            byte[] b = JTarCompressionUtils.createChecksum(file);
            String result = "";
            for (int i = 0; i < b.length; ++i) {
                result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
            entry = new ChecksumCacheEntry();
            entry.timeStamp = file.getFile().lastModified();
            entry.checksum = result;
            fChecksumCache.put(name, entry);
            return result;
        }
        catch (Exception e) {
            DeploymentManager.fDeploymentFailed = true;
            if (fFeedback != null) {
                fFeedback.error(kModule, "Cannot calculate checksum  for the file " + file.getAbsolutePath() + " : " + e.getMessage());
                if (fFeedback.isDebugEnabled(kModule)) {
                    fFeedback.debug(kModule, "Cannot get checksum: ", (Throwable)e);
                }
            }
            return null;
        }
    }

    private static class CheckSumCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        private CheckSumCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> arg0) {
            return this.size() > 100;
        }
    }

    private static class ChecksumCacheEntry {
        long timeStamp;
        String checksum;

        private ChecksumCacheEntry() {
        }
    }
}

