/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.wily.introscope.agent.AgentShim;
import java.io.IOException;
import java.net.AgentSocketOutputStream;
import java.net.PlainSocketImpl;
import java.net.SocketOutputStream;

public final class ManagedSocketOutputStreamHighPerformance
extends SocketOutputStream {
    private final AgentSocketOutputStream agentSocketOutputStream = new AgentSocketOutputStream();

    ManagedSocketOutputStreamHighPerformance(PlainSocketImpl impl) throws IOException {
        super(impl);
        this.agentSocketOutputStream.setCache(impl.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(int b) throws IOException {
        String methodName = "write(int )";
        if (this.agentSocketOutputStream.getCache() == null) {
            super.write(b);
            return;
        }
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode((Object)tl)) {
            super.write(b);
            return;
        }
        boolean addedConcurrentWriter = false;
        try {
            AgentShim.setThreadInAgentCode((Object)tl);
            addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(int )");
            if (this.agentSocketOutputStream.getCache().isClientConnection()) {
                this.agentSocketOutputStream.annotateBlameStack();
                this.agentSocketOutputStream.suggestStackTraceRecording();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError((String)"Exception preparing write(int) in High Performance Output Stream ", (Throwable)t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode((Object)tl);
        }
        try {
            super.write(b);
            AgentShim.setThreadInAgentCode((Object)tl);
            this.agentSocketOutputStream.addToOutputBandwidth(1);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(int )");
            AgentShim.clearThreadInAgentCode((Object)tl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] b) throws IOException {
        String methodName = "write(byte )";
        if (this.agentSocketOutputStream.getCache() == null) {
            super.write(b);
            return;
        }
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode((Object)tl)) {
            super.write(b);
            return;
        }
        boolean addedConcurrentWriter = false;
        try {
            AgentShim.setThreadInAgentCode((Object)tl);
            addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte )");
            if (this.agentSocketOutputStream.getCache().isClientConnection()) {
                this.agentSocketOutputStream.annotateBlameStack();
                this.agentSocketOutputStream.suggestStackTraceRecording();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError((String)"Exception preparing write(byte[]) in High Performance Output Stream ", (Throwable)t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode((Object)tl);
        }
        try {
            super.write(b);
            AgentShim.setThreadInAgentCode((Object)tl);
            if (b != null) {
                this.agentSocketOutputStream.addToOutputBandwidth(b.length);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte )");
            AgentShim.clearThreadInAgentCode((Object)tl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] b, int off, int len) throws IOException {
        String methodName = "write(byte, int, int)";
        if (this.agentSocketOutputStream.getCache() == null) {
            super.write(b, off, len);
            return;
        }
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode((Object)tl)) {
            super.write(b, off, len);
            return;
        }
        boolean addedConcurrentWriter = false;
        try {
            AgentShim.setThreadInAgentCode((Object)tl);
            addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte, int, int)");
            if (this.agentSocketOutputStream.getCache().isClientConnection()) {
                this.agentSocketOutputStream.annotateBlameStack();
                this.agentSocketOutputStream.suggestStackTraceRecording();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError((String)"Exception preparing write(byte[],int,int) in High Performance Output Stream ", (Throwable)t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode((Object)tl);
        }
        try {
            super.write(b, off, len);
            AgentShim.setThreadInAgentCode((Object)tl);
            this.agentSocketOutputStream.addToOutputBandwidth(len);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte, int, int)");
            AgentShim.clearThreadInAgentCode((Object)tl);
        }
    }
}

