/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.AttributeSubscriber;
import com.ca.apm.agent.jmxclient.api.BasicJmxMetricNameFormatter;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.CustomConfigProvider;
import com.ca.apm.agent.jmxclient.api.JmxAttributeOperationSubscriber;
import com.ca.apm.agent.jmxclient.api.JmxBeanPoller;
import com.ca.apm.agent.jmxclient.api.JmxCustomBeanConfig;
import com.ca.apm.agent.jmxclient.api.JmxMetricInfo;
import com.ca.apm.agent.jmxclient.api.JmxMetricNameFormatter;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.api.MixedConfigProvider;
import com.ca.apm.agent.jmxclient.api.OperationSubscriber;
import com.ca.apm.agent.jmxclient.api.TaskExecutor;
import com.ca.apm.agent.jmxclient.metrics.ListenerFactoriesRepo;
import com.ca.apm.agent.jmxclient.metrics.MetricType;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import com.ca.apm.agent.jmxclient.metrics.MultiValueAdaptor;
import com.ca.apm.agent.jmxclient.metrics.ValueAdder;
import com.ca.apm.agent.jmxclient.metrics.ValueMultiplier;
import com.ca.apm.agent.jmxclient.springboot.actuator.ActuatorAdapter;
import com.ca.apm.agent.jmxclient.springboot.actuator.MetricsBeanConfig;
import com.ca.apm.agent.jmxclient.springboot.actuator.WebsphereBeanConfig;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class BeanConfiguration {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final MBeanServerConnection server;
    private final JmxNodeInfo nodeInfo;
    private final TaskExecutor taskExecutor;
    private final ConfigProvider configProvider;
    private final AtomicReference<Set<JmxBeanPoller>> nodePollersRef = new AtomicReference();
    private final AtomicBoolean submittedConfigTask = new AtomicBoolean();
    private final JmxMetricNameFormatter formatter;
    public final AtomicInteger beanCount = new AtomicInteger();
    private final Set<ScheduledFuture<?>> futures = new HashSet();
    private Map<String, JmxAttributeOperationSubscriber> metricMap = new ConcurrentHashMap<String, JmxAttributeOperationSubscriber>();
    private final Lock configUpdateLock = new ReentrantLock();
    private final AtomicBoolean isClosed = new AtomicBoolean();
    public static final Map<String, AttributeValueType> SUPPORTED_VALUE_TYPES = new HashMap<String, AttributeValueType>();
    private static final Map<String, JmxCustomBeanConfig> customBeanConfigLowercaseMap;
    public final ListenerFactoriesRepo.MetricValueListenerFactory<Number> integerPercentageFactory;

    public BeanConfiguration(MBeanServerConnection server, JmxNodeInfo nodeInfo, Set<ObjectName> blackListedBeans, TaskExecutor taskExecutor) {
        this.server = server;
        this.nodeInfo = nodeInfo;
        this.taskExecutor = taskExecutor;
        this.formatter = new BasicJmxMetricNameFormatter(nodeInfo);
        this.nodePollersRef.set(Collections.emptySet());
        JmxMetricInfo metricInfo = nodeInfo.getMetricInfo();
        boolean autoConfigEnabled = metricInfo.isAutoConfigEnabled();
        CustomConfigProvider customConfig = new CustomConfigProvider(server, nodeInfo, metricInfo.getConfigModulePaths());
        this.addJmxCorIdToVertex();
        if (autoConfigEnabled) {
            QueryExp queryExp = Utils.jmxQueryExp(metricInfo.getWhiteListPatterns(), metricInfo.getBlackListPatterns(), blackListedBeans);
            this.configProvider = new MixedConfigProvider(server, nodeInfo, queryExp, customConfig);
        } else {
            this.configProvider = customConfig;
        }
        MetricsBeanConfig customBeanConfig = new MetricsBeanConfig(server, nodeInfo, this);
        customBeanConfigLowercaseMap.put("org.springframework.boot:name=metrics,type=endpoint", customBeanConfig);
        customBeanConfigLowercaseMap.put("org.springframework.boot:name=metricsendpoint,type=endpoint", customBeanConfig);
        customBeanConfigLowercaseMap.put("org.springframework.boot:name=dumpendpoint,type=endpoint", customBeanConfig);
        customBeanConfigLowercaseMap.put("websphere:feature=kernel,name=serverendpointcontrol", new WebsphereBeanConfig(server));
        this.integerPercentageFactory = new ListenerFactoriesRepo.IntegerPercentageMetricFactory<Number>(Number.class, taskExecutor, Configuration.getPollingIntervalMillis(nodeInfo));
    }

    public BeanConfiguration(MBeanServerConnection server, JmxNodeInfo nodeInfo, TaskExecutor taskExecutor) {
        this(server, nodeInfo, Collections.emptySet(), taskExecutor);
    }

    public Set<JmxBeanPoller> getPollersForServerNode() {
        Set<JmxBeanPoller> pollers = this.nodePollersRef.get();
        if (pollers.size() > 0) {
            return pollers;
        }
        if (!this.submittedConfigTask.get()) {
            try {
                final Runnable configTask = new Runnable(){

                    @Override
                    public void run() {
                        if (BeanConfiguration.this.isClosed.get()) {
                            return;
                        }
                        Set prevPollers = (Set)BeanConfiguration.this.nodePollersRef.get();
                        BeanConfiguration.this.configUpdateLock.lock();
                        try {
                            if (!BeanConfiguration.this.isClosed.get()) {
                                BeanConfiguration.this.nodePollersRef.set(BeanConfiguration.this.createJmxBeanPollers());
                            }
                        }
                        finally {
                            BeanConfiguration.this.configUpdateLock.unlock();
                        }
                        BeanConfiguration.this.beanCount.set(BeanConfiguration.this.getMbeanCount());
                        Set<T>[] diffSets = Utils.getDifferenceAsPairOfSets(prevPollers, (Set)BeanConfiguration.this.nodePollersRef.get());
                        Set removed = diffSets[0];
                        if (!removed.isEmpty()) {
                            LOGGER.logDebugMessage("JMX Configuration Reset. Stopping invalid pollers.");
                            for (JmxBeanPoller poller : removed) {
                                poller.onStop();
                            }
                        }
                    }
                };
                if (Configuration.isHardSyncEnabled()) {
                    long period = Configuration.getHardSyncInterval(this.nodeInfo);
                    this.futures.add(this.taskExecutor.scheduleAtFixedRate(configTask, 0L, period, TimeUnit.SECONDS));
                } else {
                    configTask.run();
                }
                if (Configuration.isSoftSyncEnabled()) {
                    Runnable softSyncTask = new Runnable(){

                        @Override
                        public void run() {
                            int count = BeanConfiguration.this.getMbeanCount();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.logDebugMessage("Mbean count for jmx server '" + BeanConfiguration.this.nodeInfo.getHostPort() + "' : " + count);
                            }
                            if (count != BeanConfiguration.this.beanCount.get()) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.logDebugMessage("JMX Configuration Reset for jmx server " + BeanConfiguration.this.nodeInfo.getHostPort());
                                }
                                configTask.run();
                            }
                        }
                    };
                    this.futures.add(this.taskExecutor.scheduleAtFixedRate(softSyncTask, Configuration.getSoftSyncInterval(), Configuration.getSoftSyncInterval(), TimeUnit.SECONDS));
                }
                this.submittedConfigTask.set(true);
            }
            catch (Exception e) {
                LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
            }
        }
        return this.nodePollersRef.get();
    }

    private int getMbeanCount() {
        try {
            return this.server.getMBeanCount();
        }
        catch (IOException e) {
            LOGGER.logDebugMessage("Error while fetching mbean count", (Throwable)e);
            return -1;
        }
    }

    private Set<JmxBeanPoller> createJmxBeanPollers() {
        Map<ObjectName, List<JmxAttributeOperationSubscriber>> suscribersMap = this.createSubscribersMap();
        if (suscribersMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<JmxBeanPoller> beanPollers = new HashSet<JmxBeanPoller>();
        for (Map.Entry<ObjectName, List<JmxAttributeOperationSubscriber>> entry : suscribersMap.entrySet()) {
            beanPollers.add(new JmxBeanPoller(entry.getKey(), entry.getValue()));
        }
        return beanPollers;
    }

    private Map<ObjectName, List<JmxAttributeOperationSubscriber>> createSubscribersMap() {
        HashMap<ObjectName, List<JmxAttributeOperationSubscriber>> suscribersMap = new HashMap<ObjectName, List<JmxAttributeOperationSubscriber>>();
        Map<ObjectName, Map<String, Set<BeanConfigElement>>> configElements = this.configProvider.getConfig();
        Set<ObjectName> names = configElements.keySet();
        if (configElements.size() == 0) {
            LOGGER.logDebugMessage("No Mbeans found that match the filter criteria");
            return Collections.emptyMap();
        }
        try {
            for (ObjectName name : names) {
                Map<String, Set<BeanConfigElement>> atConfigMap = configElements.get(name);
                ArrayList<? extends JmxAttributeOperationSubscriber> subscribers = new ArrayList<JmxAttributeOperationSubscriber>();
                MBeanInfo beanInfo = this.server.getMBeanInfo(name);
                if (atConfigMap != null) {
                    MBeanOperationInfo[] opInfos;
                    MBeanAttributeInfo[] atInfos;
                    for (MBeanAttributeInfo atInfo : atInfos = beanInfo.getAttributes()) {
                        Set<BeanConfigElement> atConfigElements;
                        Object value = null;
                        try {
                            value = this.server.getAttribute(name, atInfo.getName());
                        }
                        catch (Exception e) {
                            LOGGER.logDebugMessage("Error creating Subscriber for object - " + name + ", attribute - " + atInfo.getName() + " : " + e.getMessage());
                            if (!LOGGER.isTraceEnabled()) continue;
                            LOGGER.logTraceMessage(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        if (value == null || (atConfigElements = atConfigMap.get(atInfo.getName())) == null) continue;
                        subscribers.addAll(this.createAttributeSubscribers(name, beanInfo, atInfo, atConfigElements));
                    }
                    for (MBeanOperationInfo opInfo : opInfos = beanInfo.getOperations()) {
                        Set<BeanConfigElement> opConfigElements = atConfigMap.get(opInfo.getName());
                        if (opConfigElements == null) continue;
                        subscribers.addAll(this.createOperationSubscribers(name, beanInfo, opInfo, opConfigElements));
                    }
                }
                suscribersMap.put(name, subscribers);
            }
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Got exception while creating subscribers for jmx server: " + this.nodeInfo.getHost(), (Throwable)e);
        }
        return suscribersMap;
    }

    private Set<JmxAttributeOperationSubscriber> createAttributeSubscribers(ObjectName name, MBeanInfo beanInfo, MBeanAttributeInfo atInfo, Set<BeanConfigElement> elements) {
        HashSet<JmxAttributeOperationSubscriber> subscribers = new HashSet<JmxAttributeOperationSubscriber>();
        for (BeanConfigElement element : elements) {
            JmxAttributeOperationSubscriber e = this.getAttributeSubscriber(element, name, beanInfo, atInfo);
            if (e == null) continue;
            subscribers.add(e);
        }
        return subscribers;
    }

    private JmxAttributeOperationSubscriber getAttributeSubscriber(BeanConfigElement element, ObjectName objectName, MBeanInfo beanInfo, MBeanAttributeInfo atInfo) {
        MetricType metricType = element.getMetricTypeEnum();
        if (metricType == null) {
            return null;
        }
        AttributeValueType attValueType = SUPPORTED_VALUE_TYPES.get(atInfo.getType());
        String metricName = this.formatter.format(element.getMetricName(), element.getObjectName(), objectName, beanInfo, atInfo, null);
        if (this.metricMap.get(metricName) != null) {
            return this.metricMap.get(metricName);
        }
        MetricValueListener<?> listener = null;
        if (MetricType.COUNTER == metricType) {
            listener = this.createNumberMetricListener(ListenerFactoriesRepo.FLUCTUATING_COUNTER_FACTORY, metricName, element, attValueType);
        } else if (MetricType.INTEGER_COUNTER == metricType) {
            listener = this.createNumberMetricListener(ListenerFactoriesRepo.FLUCTUATING_INTEGER_COUNTER_FACTORY, metricName, element, attValueType);
        } else if (MetricType.INTEGER_PERCENTAGE == metricType) {
            listener = this.createNumberMetricListener(this.integerPercentageFactory, metricName, element, attValueType);
        } else if (MetricType.INTERVAL_COUNTER == metricType) {
            listener = this.createNumberMetricListener(ListenerFactoriesRepo.PER_INTERVAL_COUNTER_FACTORY, metricName, element, attValueType);
        } else if (MetricType.RATE == metricType) {
            listener = this.createNumberMetricListener(ListenerFactoriesRepo.RATE_FACTORY, metricName, element, attValueType);
        } else if (MetricType.STRING == metricType || MetricType.STRING_EVENT == metricType) {
            listener = this.createStringMetricListener(ListenerFactoriesRepo.STRING_FACTORY, metricName, element, attValueType);
        }
        if (listener == null) {
            return null;
        }
        AttributeSubscriber subscriber = new AttributeSubscriber(objectName, atInfo.getName(), listener);
        this.metricMap.put(metricName, subscriber);
        return subscriber;
    }

    private Collection<? extends JmxAttributeOperationSubscriber> createOperationSubscribers(ObjectName name, MBeanInfo beanInfo, MBeanOperationInfo opInfo, Set<BeanConfigElement> elements) {
        HashSet<JmxAttributeOperationSubscriber> subscribers = new HashSet<JmxAttributeOperationSubscriber>();
        for (BeanConfigElement element : elements) {
            JmxAttributeOperationSubscriber e = this.getOperationSubscriber(element, name, beanInfo, opInfo);
            if (e == null) continue;
            subscribers.add(e);
        }
        return subscribers;
    }

    private JmxAttributeOperationSubscriber getOperationSubscriber(BeanConfigElement element, ObjectName name, MBeanInfo beanInfo, MBeanOperationInfo opInfo) {
        if (element.getOperationName() != null) {
            int paramsCountInConfig;
            int paramsCount = opInfo.getSignature().length;
            int n = paramsCountInConfig = element.getOperationParameters() == null ? 0 : element.getOperationParameters().size();
            if (paramsCount != paramsCountInConfig) {
                return null;
            }
            String[] opSig = new String[paramsCount];
            Object[] opParams = new Object[paramsCount];
            try {
                for (int i = 0; i < paramsCount; ++i) {
                    opSig[i] = opInfo.getSignature()[i].getType();
                    String param = element.getOperationParameters().get(i);
                    if (opSig[i].equalsIgnoreCase(String.class.getName())) {
                        opParams[i] = param.equalsIgnoreCase("n/a") ? "" : param;
                        continue;
                    }
                    if (opSig[i].equalsIgnoreCase(List.class.getName())) {
                        opParams[i] = param.equalsIgnoreCase("n/a") ? new ArrayList() : new ArrayList<String>(Arrays.asList(param.split(",")));
                        continue;
                    }
                    if (opSig[i].equalsIgnoreCase(new String[0].getClass().getName())) {
                        opParams[i] = param.equalsIgnoreCase("n/a") ? new String[]{} : param.split(",");
                        continue;
                    }
                    if (opSig[i].equalsIgnoreCase(Long.TYPE.getName())) {
                        opParams[i] = Long.parseLong(param);
                        continue;
                    }
                    if (opSig[i].equalsIgnoreCase(new long[0].getClass().getName())) {
                        if (param.equalsIgnoreCase("n/a")) {
                            opParams[i] = new long[0];
                            continue;
                        }
                        String[] splitParam = param.split(",");
                        long[] paraml = new long[splitParam.length];
                        int j = 0;
                        for (String p : splitParam) {
                            paraml[j] = Long.parseLong(p);
                            ++j;
                        }
                        opParams[i] = paraml;
                        continue;
                    }
                    if (opSig[i].equalsIgnoreCase(Boolean.TYPE.getName())) {
                        opParams[i] = Boolean.parseBoolean(param);
                        continue;
                    }
                    return null;
                }
                Object i = this.server.invoke(name, element.getOperationName(), opParams, opSig);
            }
            catch (Exception e) {
                return null;
            }
            MetricType metricType = element.getMetricTypeEnum();
            if (metricType == null && element.isSingleValueTransfomer()) {
                return null;
            }
            String metricName = this.formatter.format(element.getMetricName(), element.getObjectName(), name, beanInfo, null, opInfo);
            if (this.metricMap.get(metricName) != null) {
                return this.metricMap.get(metricName);
            }
            MetricValueListener<?> listener = null;
            if (!element.isSingleValueTransfomer()) {
                if (element.getValueTransformer() != null) {
                    MetricValueTransformer<?, ?> transformer = Utils.getTransformerInstance(element.getValueTransformer());
                    listener = new MultiValueAdaptor(transformer, metricName);
                } else {
                    listener = new ActuatorAdapter(metricName, this.nodeInfo.getMetricInfo());
                }
            } else if (MetricType.COUNTER == metricType) {
                listener = this.createNumberMetricListener(ListenerFactoriesRepo.FLUCTUATING_COUNTER_FACTORY, metricName, element, AttributeValueType.LONG);
            } else if (MetricType.INTERVAL_COUNTER == metricType) {
                listener = this.createNumberMetricListener(ListenerFactoriesRepo.PER_INTERVAL_COUNTER_FACTORY, metricName, element, AttributeValueType.LONG);
            } else if (MetricType.RATE == metricType) {
                listener = this.createNumberMetricListener(ListenerFactoriesRepo.RATE_FACTORY, metricName, element, AttributeValueType.LONG);
            } else if (MetricType.STRING == metricType || MetricType.STRING_EVENT == metricType) {
                listener = this.createStringMetricListener(ListenerFactoriesRepo.STRING_FACTORY, metricName, element, AttributeValueType.STRING);
            } else if (MetricType.BOOLEAN == metricType) {
                listener = this.createBooleanMetricListener(ListenerFactoriesRepo.BOOLEAN_FACTORY, metricName, element, AttributeValueType.BOOLEAN);
            }
            if (listener == null) {
                return null;
            }
            OperationSubscriber subscriber = new OperationSubscriber(name, element.getOperationName(), opSig, opParams, listener);
            this.metricMap.put(metricName, subscriber);
            return subscriber;
        }
        return null;
    }

    private MetricValueListener<?> createNumberMetricListener(ListenerFactoriesRepo.MetricValueListenerFactory<Number> fac, String metricName, BeanConfigElement element, AttributeValueType attValueType) {
        MetricValueTransformer<?, ?> transformer;
        if (element.getValueTransformer() != null && (transformer = Utils.getTransformerInstance(element.getValueTransformer())) != null) {
            return ListenerFactoriesRepo.GENERIC_NUMERIC_ADAPTOR_FACTORY.createMetricListener(transformer, fac.createMetricListener(metricName));
        }
        if (attValueType == null) {
            LOGGER.logWarningMessage("Noticed Unsupported value type for bean: " + element.getObjectName() + ", attribute: " + element.getAttribute() + ". Ignoring it for metric reporting.");
            return null;
        }
        MetricValueListener<Number> listener = null;
        if (!fac.isSupportedType(attValueType.getValueTypeClass())) {
            LOGGER.logWarningMessage("Incorrect metric type configured for bean: " + element.getObjectName() + ". It does not support value type:" + attValueType.getValueTypeClass());
            return null;
        }
        listener = fac.createMetricListener(metricName);
        MetricValueTransformer transformer2 = null;
        if (element.getValueFactor() != 1.0) {
            transformer2 = new ValueMultiplier(element.getValueFactor());
        } else if (element.getValueAddition() != 0.0) {
            transformer2 = new ValueAdder((int)element.getValueAddition());
        } else if (element.getValueSpecialTransformer() != null) {
            transformer2 = element.getValueSpecialTransformer();
        }
        if (transformer2 != null) {
            listener = ListenerFactoriesRepo.NUMERIC_OP_ADAPTOR_FACTORY.createMetricListener(transformer2, listener);
        }
        return listener;
    }

    private MetricValueListener<?> createStringMetricListener(ListenerFactoriesRepo.MetricValueListenerFactory<String> fac, String metricName, BeanConfigElement element, AttributeValueType attValueType) {
        MetricValueTransformer<?, ?> transformer;
        if (element.getValueTransformer() != null && (transformer = Utils.getTransformerInstance(element.getValueTransformer())) != null) {
            return ListenerFactoriesRepo.GENERIC_STRING_ADAPTOR_FACTORY.createMetricListener(transformer, fac.createMetricListener(metricName));
        }
        if (attValueType == null) {
            LOGGER.logWarningMessage("Noticed Unsupported value type for bean: " + element.getObjectName() + ", attribute: " + element.getAttribute() + ". Ignoring it for metric reporting.");
            return null;
        }
        if (fac.isSupportedType(attValueType.getValueTypeClass())) {
            MetricValueListener<String> listener = fac.createMetricListener(metricName);
            return listener;
        }
        LOGGER.logWarningMessage("Incorrect metric type configured for bean: " + element.getObjectName() + ". It does not support value type:" + attValueType.getValueTypeClass());
        return null;
    }

    private MetricValueListener<?> createBooleanMetricListener(ListenerFactoriesRepo.MetricValueListenerFactory<Boolean> fac, String metricName, BeanConfigElement element, AttributeValueType attValueType) {
        MetricValueTransformer<?, ?> transformer;
        if (element.getValueTransformer() != null && (transformer = Utils.getTransformerInstance(element.getValueTransformer())) != null) {
            return new ListenerFactoriesRepo.AdaptorFactory().createMetricListener(transformer, fac.createMetricListener(metricName));
        }
        if (attValueType == null) {
            LOGGER.logWarningMessage("Noticed Unsupported value type for bean: " + element.getObjectName() + ", attribute: " + element.getAttribute() + ". Ignoring it for metric reporting.");
            return null;
        }
        if (fac.isSupportedType(attValueType.getValueTypeClass())) {
            MetricValueListener<Boolean> listener = fac.createMetricListener(metricName);
            return listener;
        }
        LOGGER.logWarningMessage("Incorrect metric type configured for bean: " + element.getObjectName() + ". It does not support value type:" + attValueType.getValueTypeClass());
        return null;
    }

    void close() {
        this.isClosed.set(true);
        for (ScheduledFuture<?> f : this.futures) {
            f.cancel(false);
        }
        this.futures.clear();
        this.configUpdateLock.lock();
        try {
            for (JmxBeanPoller poller : this.nodePollersRef.get()) {
                poller.onStop();
            }
        }
        finally {
            this.configUpdateLock.unlock();
        }
    }

    ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public void addJmxCorIdToVertex() {
        try {
            RuntimeMXBean proxy = ManagementFactory.getPlatformMXBean(this.server, RuntimeMXBean.class);
            Map<String, String> sysprops = proxy.getSystemProperties();
            String jmxCorIdValue = sysprops.get("jmxCorId");
            if (jmxCorIdValue != null) {
                this.nodeInfo.getAtcVertexInfo().setJmxCorId(jmxCorIdValue);
            }
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Exception while connecting to MBeanServer ");
        }
    }

    public static Map<String, JmxCustomBeanConfig> getCustomBeanConfigLowercaseMap() {
        return customBeanConfigLowercaseMap;
    }

    static {
        SUPPORTED_VALUE_TYPES.put("long", AttributeValueType.LONG);
        SUPPORTED_VALUE_TYPES.put("java.lang.Long", AttributeValueType.LONG);
        SUPPORTED_VALUE_TYPES.put("int", AttributeValueType.INTEGER);
        SUPPORTED_VALUE_TYPES.put("float", AttributeValueType.INTEGER);
        SUPPORTED_VALUE_TYPES.put("java.lang.Integer", AttributeValueType.INTEGER);
        SUPPORTED_VALUE_TYPES.put("double", AttributeValueType.LONG);
        SUPPORTED_VALUE_TYPES.put("java.lang.Number", AttributeValueType.LONG);
        SUPPORTED_VALUE_TYPES.put("java.lang.String", AttributeValueType.STRING);
        SUPPORTED_VALUE_TYPES.put("java.lang.Boolean", AttributeValueType.BOOLEAN);
        SUPPORTED_VALUE_TYPES.put("java.lang.Object", AttributeValueType.LONG);
        SUPPORTED_VALUE_TYPES.put("java.lang.Double", AttributeValueType.DOUBLE);
        customBeanConfigLowercaseMap = new HashMap<String, JmxCustomBeanConfig>();
    }

    static interface ConfigProvider {
        public Map<ObjectName, Map<String, Set<BeanConfigElement>>> getConfig();
    }

    public static enum AttributeValueType {
        LONG(Long.class, MetricType.COUNTER),
        INTEGER(Integer.class, MetricType.COUNTER),
        FLOAT(Integer.class, MetricType.COUNTER),
        DOUBLE(Integer.class, MetricType.COUNTER),
        STRING(String.class, MetricType.STRING),
        BOOLEAN(Boolean.class, MetricType.BOOLEAN);

        private Class<?> valueType;
        private MetricType defaultMetricType;

        private AttributeValueType(Class<?> valueType) {
            this.valueType = valueType;
        }

        private AttributeValueType(Class<?> valueType, MetricType metricType) {
            this.valueType = valueType;
            this.defaultMetricType = metricType;
        }

        public Class<?> getValueTypeClass() {
            return this.valueType;
        }

        public MetricType getDefaultMetricType() {
            return this.defaultMetricType;
        }
    }
}

