/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.helper;

import com.ca.apm.parent.instrumentation.ParentCandidateAnalyzer;
import com.ca.apm.parent.instrumentation.helper.FilePersistenceServiceStatusHelper;
import com.ca.apm.parent.instrumentation.helper.ParentInstrumentationConfig;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveSharedTracerHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class JMSReceiveStackTTraceController {
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static AtomicInteger maxLimit = new AtomicInteger(0);

    public static void init(IAgent agent) {
        if (initialized.compareAndSet(false, true)) {
            ParentCandidateAnalyzer.InitializeService(agent);
        }
    }

    public static boolean shouldRecordStackTrace(InvocationData data) {
        boolean result;
        boolean bl = result = JMSHelper.isStackEmpty(data) && !JMSReceiveStackTTraceController.isParentAlreadyInstrumented(data) && !FilePersistenceServiceStatusHelper.isMaskSet(127);
        if (result) {
            if (maxLimit.get() >= ParentInstrumentationConfig.getReceiveStackDataClampSize()) {
                return false;
            }
            maxLimit.incrementAndGet();
        }
        return result;
    }

    public static boolean isParentAlreadyInstrumented(InvocationData data) {
        return JMSReceiveSharedTracerHelper.isParentAlreadyInstrumented(data);
    }

    public static void setParentInstrumented(InvocationData data, boolean b) {
        JMSReceiveSharedTracerHelper.setParentInstrumented(data, b);
    }

    public static void resetLimitCounter() {
        maxLimit.set(0);
    }

    public static void decrementLimitCounter() {
        maxLimit.decrementAndGet();
    }
}

