/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection;

import com.wily.introscope.agent.TraceRecorder;
import com.wily.introscope.agent.intelligent.detection.ConditionalTraceRecorder;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.detection.StackTraceProvider;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointRecordingData;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.EntryPointStackTraceRecorder;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointCandidateFinder;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointRecordingData;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.ExitPointStackTraceRecorder;
import com.wily.introscope.probebuilder.extension.instrument.intelligent.IntelligentInstrumentationService;
import com.wily.util.feedback.SeverityLevel;
import java.util.concurrent.atomic.AtomicInteger;

public class StackTraceRecorder
implements TraceRecorder {
    private final int MAX_MESSAGES_TO_LOG = 10;
    private AtomicInteger loggedMsgsCounter = new AtomicInteger(0);
    private final ConditionalTraceRecorder entryPointTraceRecorder = new EntryPointStackTraceRecorder();
    private final ExitPointStackTraceRecorder exitPointTraceRecorder = new ExitPointStackTraceRecorder();
    private static final RecordingDataWrapperThreadLocal threadLocalWrapper = new RecordingDataWrapperThreadLocal();
    public static final StackTraceProvider NOOP_TRACE_PROVIDER = new StackTraceProvider(){

        @Override
        public StackTraceElement[] getTrace() {
            return null;
        }
    };

    private StackTraceRecorder() {
    }

    public boolean record() {
        try {
            boolean recorded;
            if (IntelligentInstrumentationService.isMaskSet(31)) {
                return false;
            }
            RecordingDataWrapper dataWrapper = (RecordingDataWrapper)threadLocalWrapper.get();
            RecordingData entryPointData = dataWrapper.getEntryPointRecordingData();
            RecordingData exitPointData = dataWrapper.getExitPointRecordingData();
            return recorded |= this.entryPointTraceRecorder.record(entryPointData, (recorded = this.exitPointTraceRecorder.record(exitPointData, NOOP_TRACE_PROVIDER)) ? exitPointData : NOOP_TRACE_PROVIDER);
        }
        catch (Throwable e) {
            if (this.loggedMsgsCounter.getAndIncrement() < 10) {
                Logger.logMessage((String)"Error in StackTraceRecorder while recording stack trace", (SeverityLevel)SeverityLevel.ERROR);
                Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public static StackTraceRecorder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static RecordingData getEntryPointRecordingData() {
        return ((RecordingDataWrapper)threadLocalWrapper.get()).getEntryPointRecordingData();
    }

    public static RecordingData getExitPointRecordingData() {
        return ((RecordingDataWrapper)threadLocalWrapper.get()).getExitPointRecordingData();
    }

    public ConditionalTraceRecorder getEntryPointStackTraceRecorder() {
        return this.entryPointTraceRecorder;
    }

    public ExitPointStackTraceRecorder getExitPointStackTraceRecorder() {
        return this.exitPointTraceRecorder;
    }

    public static ConditionalTraceRecorder getEntryPointRecorder() {
        return StackTraceRecorder.getInstance().getEntryPointStackTraceRecorder();
    }

    public static ExitPointStackTraceRecorder getExitPointRecorder() {
        return StackTraceRecorder.getInstance().getExitPointStackTraceRecorder();
    }

    private static class RecordingDataWrapperThreadLocal
    extends ThreadLocal<RecordingDataWrapper> {
        private RecordingDataWrapperThreadLocal() {
        }

        @Override
        public RecordingDataWrapper initialValue() {
            return new RecordingDataWrapper();
        }
    }

    private static class RecordingDataWrapper {
        private final RecordingData[] dataArray;

        public RecordingDataWrapper() {
            ExitPointRecordingData exitPointData = new ExitPointRecordingData();
            ExitPointCandidateFinder.getInstance().registerRecordingData(exitPointData);
            this.dataArray = new RecordingData[2];
            this.dataArray[0] = new EntryPointRecordingData();
            this.dataArray[1] = exitPointData;
        }

        public RecordingData getEntryPointRecordingData() {
            return this.dataArray[0];
        }

        public RecordingData getExitPointRecordingData() {
            return this.dataArray[1];
        }
    }

    private static class SingletonHolder {
        private static final StackTraceRecorder INSTANCE = new StackTraceRecorder();

        private SingletonHolder() {
        }
    }
}

