/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.KAgentConstants;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.connection.NamedAgentBridgeInfo;
import com.wily.introscope.agent.connection.NamedAgentBridgeVisitor;
import com.wily.introscope.agent.environment.EnvironmentAdministrator;
import com.wily.introscope.agent.environment.JsonGenerator;
import com.wily.introscope.agent.runtime.java.environment.EnvironmentStatisticsHandler;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallClient;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpResponse;
import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class AgentInformationReporter
implements NamedAgentBridgeVisitor {
    private static final int REPORT_INTERVAL = 1800000;
    private volatile IAgent agent;
    private long lastReport = 0L;
    private final EnvironmentAdministrator envAdmin;

    AgentInformationReporter(EnvironmentAdministrator envAdmin, IAgent agent) {
        this.envAdmin = envAdmin;
        this.agent = agent;
    }

    private String resolveAgentTypeString() {
        KAgentConstants.EAgentType type = this.agent.IAgent_getType();
        switch (type) {
            case InfrastructureAgent: {
                return "infrastructure";
            }
            case JavaAgent: {
                return "java";
            }
            case TestAgent: {
                return "test";
            }
        }
        return null;
    }

    public void reportEnvironmentInformation() {
        block3: {
            try {
                boolean result;
                String[] agentTriplet = this.agent.IAgent_getHostProcessAgentTriplet();
                String qualifiedAgent = agentTriplet[0] + "|" + agentTriplet[1] + "|" + agentTriplet[2];
                String type = this.resolveAgentTypeString();
                if (Math.abs(System.currentTimeMillis() - this.lastReport) > 1800000L && (result = this.reportEnvironmentInformationInner(qualifiedAgent, type, null, true, true))) {
                    this.lastReport = System.currentTimeMillis();
                }
            }
            catch (Exception e) {
                if (this.agent == null) break block3;
                this.agent.IAgent_getModuleFeedback().error(e);
            }
        }
    }

    public void reportNamedAgentBridgeInformation(NamedAgentBridgeInfo info) {
        block3: {
            try {
                boolean result;
                String qualifiedAgent = info.getHost() + "|" + info.getProcess() + "|" + info.getAgentName();
                String[] agentTriplet = this.agent.IAgent_getHostProcessAgentTriplet();
                String hostingAgent = agentTriplet[0] + "|" + agentTriplet[1] + "|" + agentTriplet[2];
                long lastReported = info.getLastTimeAttributesReported();
                if (Math.abs(System.currentTimeMillis() - lastReported) > 1800000L && (result = this.reportEnvironmentInformationInner(qualifiedAgent, info.getAgentType(), hostingAgent, false, false))) {
                    info.setLastTimeAttributesReported(System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                if (this.agent == null) break block3;
                this.agent.IAgent_getModuleFeedback().error(e);
            }
        }
    }

    private boolean reportEnvironmentInformationInner(String qualifiedAgent, String type, String hostingAgent, boolean sendJvmOpts, boolean sendInterfaces) throws IOException, AgentNotAvailableException {
        if (this.agent == null || !this.agent.IAgent_isIsengardEnabled()) {
            return false;
        }
        boolean isNamedAgentBridge = hostingAgent != null;
        IsengardServerConnectionManager connection = this.agent.IAgent_getIsengardServerConnection();
        if (connection == null) {
            return false;
        }
        ConnectedServer server = connection.getConnectedServer();
        if (server != null && server.isConnected()) {
            JsonGenerator jg;
            block22: {
                List<String> arguments;
                RuntimeMXBean runtimeMxBean;
                jg = new JsonGenerator();
                jg.writeStartObject();
                jg.writeStringField("layer", "APM_INFRASTRUCTURE");
                jg.writeFieldName("graph");
                jg.writeStartObject();
                jg.writeFieldName("vertices");
                jg.writeStartArray();
                jg.writeStartObject();
                jg.writeStringField("id", "AGENT:" + qualifiedAgent);
                jg.writeFieldName("attributes");
                jg.writeStartObject();
                IStringLocalizer localizer = this.agent.IAgent_getStringLocalizer();
                IntroscopeVersion version = new IntroscopeVersion(localizer);
                jg.writeStringField("version", version.IVersion_getReleaseAndBuildString(localizer));
                jg.writeStringField("type", "AGENT");
                jg.writeStringField("name", qualifiedAgent);
                if (type != null) {
                    jg.writeStringField("agentType", type);
                }
                jg.writeStringField("osName", EnvironmentStatisticsHandler.getOsName());
                jg.writeStringField("vmVendor", EnvironmentStatisticsHandler.getVmVendor());
                jg.writeStringField("vmVersion", EnvironmentStatisticsHandler.getVmVersion());
                jg.writeStringField("TTPlugin.sourceID", "agent");
                jg.writeLongField("maxMemory", Runtime.getRuntime().maxMemory());
                jg.writeStringField("jmxCorId", System.getProperty("jmxCorId"));
                if (hostingAgent != null) {
                    jg.writeStringField("hostingAgent", hostingAgent);
                }
                if (!isNamedAgentBridge) {
                    jg.writeStringField("SystemSimpleHostName", this.envAdmin.calculateSystemSimpleHostName());
                    jg.writeStringField("SystemFQHostName", this.envAdmin.calculateSystemFullyQualifiedDomainName());
                    jg.writeStringField("ipAddress", this.envAdmin.getIPAddress());
                    String containerId = this.envAdmin.getContainerId();
                    if (containerId != null) {
                        jg.writeStringField("containerId", containerId);
                    }
                }
                if (sendJvmOpts && (runtimeMxBean = ManagementFactory.getRuntimeMXBean()) != null && (arguments = runtimeMxBean.getInputArguments()) != null) {
                    jg.writeFieldName("jvmOpts");
                    jg.writeStartArray();
                    for (String a : arguments) {
                        if (a == null || a.startsWith("-D")) continue;
                        jg.writeString(a);
                    }
                    jg.writeEndArray();
                }
                if (sendInterfaces) {
                    try {
                        jg.writeFieldName("networkInterfaces");
                        jg.writeStartArray();
                        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                        while (interfaces.hasMoreElements()) {
                            String mac;
                            NetworkInterface ni = interfaces.nextElement();
                            Enumeration<InetAddress> addresses = ni.getInetAddresses();
                            if (!ni.isUp()) continue;
                            ArrayList<Object> addresses2 = new ArrayList<Object>();
                            if (addresses != null) {
                                while (addresses.hasMoreElements()) {
                                    InetAddress address = addresses.nextElement();
                                    if (address.isLoopbackAddress() || address.getHostAddress() == null || address.getHostAddress().isEmpty()) continue;
                                    addresses2.add(address);
                                }
                            }
                            if (addresses2.isEmpty()) continue;
                            jg.writeStartObject();
                            jg.writeFieldName("inet");
                            jg.writeStartArray();
                            for (InetAddress inetAddress : addresses2) {
                                jg.writeStartObject();
                                String hostAddress = inetAddress.getHostAddress();
                                if (hostAddress.contains("%")) {
                                    hostAddress = hostAddress.substring(0, hostAddress.indexOf("%"));
                                }
                                jg.writeStringField("addr", hostAddress);
                                jg.writeStringField("host", inetAddress.getCanonicalHostName());
                                jg.writeEndObject();
                            }
                            jg.writeEndArray();
                            if (ni.getHardwareAddress() != null && !(mac = AgentInformationReporter.formatMac(ni.getHardwareAddress())).isEmpty()) {
                                jg.writeStringField("mac", mac);
                            }
                            jg.writeEndObject();
                        }
                        jg.writeEndArray();
                    }
                    catch (SocketException e) {
                        if (!this.agent.IAgent_getModuleFeedback().isTraceEnabled()) break block22;
                        this.agent.IAgent_getModuleFeedback().trace("Unable to get list of network interfaces");
                    }
                }
            }
            jg.writeEndObject();
            jg.writeEndObject();
            jg.writeEndArray();
            jg.writeFieldName("edges");
            jg.writeStartArray();
            jg.writeEndArray();
            jg.writeEndObject();
            jg.writeEndObject();
            try {
                String jsonString = jg.toString();
                if (server.getPostOffice() == null) {
                    this.agent.IAgent_getModuleFeedback().debug("Agent " + qualifiedAgent + " connection to EM lost, cannot send attributes");
                    return false;
                }
                RemoteHttpResponse ret = new RemoteHttpCallClient(server.getPostOffice()).doPost("/apm/appmap/ats/graph/store", jsonString, null);
                if (ret.getHttpCode() / 100 == 2) {
                    this.agent.IAgent_getModuleFeedback().info("Agent " + qualifiedAgent + " attributes sent to EM successfully");
                    this.agent.IAgent_getModuleFeedback().debug("Agent attributes: " + jsonString);
                    return true;
                }
                this.agent.IAgent_getModuleFeedback().error("Unexpected respond from topology store: " + ret.getHttpCode() + " " + ret.getReasonPhrase() + " Body:" + (ret.getResponseBody() == null ? null : new String(ret.getResponseBody())));
            }
            catch (Exception e) {
                this.agent.IAgent_getModuleFeedback().warn("Exception posting agent attributes");
                this.agent.IAgent_getModuleFeedback().debug(e);
            }
        }
        return false;
    }

    public static String formatMac(byte[] hardwareAddress) {
        StringBuilder sb = new StringBuilder(18);
        for (byte b : hardwareAddress) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public void setAgent(IAgent agent) {
        this.agent = agent;
    }

    @Override
    public void visit(NamedAgentBridgeInfo info) {
        this.reportNamedAgentBridgeInformation(info);
    }

    public void reportAllNamedAgentBridgeInformation() {
        IsengardServerConnectionManager connection = this.agent.IAgent_getIsengardServerConnection();
        if (connection == null) {
            return;
        }
        connection.acceptNamedAgentBridgeVisitor(this);
    }
}

