/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;

public class RateMetric<T extends Number>
implements MetricValueListener<T> {
    final ILongIntervalCounterDataAccumulator acc;
    private volatile MetricValueListener<T> delegate;

    public RateMetric(String metricName) {
        this.delegate = new DummyListener<T>(metricName);
        JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
        if (!clamp.isClampHit()) {
            clamp.incrementMetricCounter();
            this.acc = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName);
        } else {
            clamp.printClampWarning();
            this.acc = null;
        }
    }

    @Override
    public void update(T value) {
        this.delegate.update(value);
    }

    @Override
    public boolean validate(Object value) {
        return this.delegate.validate(value);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public int hashCode() {
        return this.acc == null ? 0 : this.acc.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RateMetric other = (RateMetric)obj;
        return !(this.acc == null ? other.acc != null : !this.acc.equals(other.acc));
    }

    long getRecordedValue() {
        if (this.delegate instanceof RateImpl) {
            return ((RateImpl)this.delegate).getRecordedValue();
        }
        return -1L;
    }

    private class RateImpl<T2 extends Number>
    implements MetricValueListener<T2> {
        private volatile long oldValue = 0L;

        public RateImpl(long oldValue) {
            this.oldValue = oldValue;
        }

        @Override
        public void update(T2 value) {
            if (RateMetric.this.acc != null) {
                long v = ((Number)value).longValue();
                if (v >= this.oldValue) {
                    RateMetric.this.acc.ILongAggregatingDataAccumulator_recordDataPoint(v - this.oldValue);
                }
                this.oldValue = v;
            }
        }

        @Override
        public boolean validate(Object value) {
            return value instanceof Number;
        }

        @Override
        public void close() {
            if (RateMetric.this.acc != null) {
                JmxClamp.getInstance(Configuration.getAgent()).decrementMetricCounter();
                Configuration.getAccumulatorFactory().removeDataAccumulator((IDataAccumulator)RateMetric.this.acc);
            }
        }

        long getRecordedValue() {
            if (RateMetric.this.acc != null) {
                double d = RateMetric.this.acc.IDataAccumulator_getGatherer().IGatherer_harvest(System.currentTimeMillis())[0].getValueAsDouble(0.0);
                return (long)d;
            }
            return -1L;
        }
    }

    private class DummyListener<T1 extends Number>
    implements MetricValueListener<T1> {
        final String metricName;

        public DummyListener(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public void update(T1 value) {
            RateMetric.this.delegate = new RateImpl(((Number)value).longValue());
        }

        @Override
        public boolean validate(Object value) {
            return value instanceof Number;
        }

        @Override
        public void close() {
        }
    }
}

