/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AsyncThreadErrorTracer
extends ASingleInstanceTracerFactoryHC {
    private static final String kErrorObjextIndexKey = "errorObject";
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncThreadErrorTracer");
    private final int errorObjectIndex;
    protected final AsyncVirtualStack asyncStack;

    public AsyncThreadErrorTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.asyncStack = AsyncVirtualStack.getInstance(agent);
        this.errorObjectIndex = this.calculateIntegerParameter(kErrorObjextIndexKey, -1);
    }

    private Object findErrorObject(InvocationData data) {
        if (this.errorObjectIndex >= 0) {
            return data.getInvocationParameterAsObject(this.errorObjectIndex);
        }
        return data.getInvocationObject();
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object errorObject = this.findErrorObject(data);
        String errorMsg = "Unspecified error.";
        if (errorObject != null) {
            errorMsg = errorObject.toString();
        }
        this.asyncStack.decorateAsyncStackWithError(data, errorMsg);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    protected void doOnAbortedTransactionEndTrace(int tracerIndex, IStackElement data) {
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }
}

