/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Multimap<K, V> {
    private transient Map<K, Collection<V>> map = new HashMap<K, Collection<V>>();

    public boolean put(K key, V value) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = new ArrayList<V>();
            if (collection.add(value)) {
                this.map.put(key, collection);
                return true;
            }
            throw new Error("New Collection violation");
        }
        return collection.add(value);
    }

    public Collection<V> get(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = new ArrayList<V>();
        }
        return collection;
    }

    public Collection<V> remove(K key) {
        return this.map.remove(key);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        for (K key : this.map.keySet()) {
            sBuilder.append(key).append("/");
            Collection<V> temp = this.map.get(key);
            if (temp == null) continue;
            for (V val : temp) {
                sBuilder.append(val).append(",");
            }
        }
        return sBuilder.toString();
    }

    public int size() {
        return this.map.size();
    }

    public int size(boolean deep) {
        int size = 0;
        if (deep) {
            for (Collection<V> value : this.map.values()) {
                size += value.size();
            }
        } else {
            size = this.map.size();
        }
        return size;
    }
}

