/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.feedback.AApplicationFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ABufferedApplicationFeedbackChannel
extends AApplicationFeedbackChannel {
    public static final String kDisableFeedbackChannelBufferKey = "com.wily.introscope.disableStartupMessageBuffering";
    public static final Module kModule = new Module("BufferedLogging");
    private final List<BufferedLogMessage> fEventList = new ArrayList<BufferedLogMessage>(10);
    private boolean fShouldBuffer = false;

    public ABufferedApplicationFeedbackChannel(String applicationName, String moduleName) {
        this(applicationName, moduleName, "DefaultSystemOut");
    }

    public ABufferedApplicationFeedbackChannel(String applicationName) {
        this(applicationName, null, "DefaultSystemOut");
    }

    public ABufferedApplicationFeedbackChannel(String applicationName, String moduleName, String defaultOutputTarget) {
        super(applicationName, moduleName, defaultOutputTarget);
        this.setShouldBuffer(!Boolean.getBoolean(kDisableFeedbackChannelBufferKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldBuffer(boolean shouldBuffer) {
        Object object = this.getFeedbackChannelLock();
        synchronized (object) {
            boolean shouldFlush = this.fShouldBuffer && !shouldBuffer;
            this.fShouldBuffer = shouldBuffer;
            if (shouldFlush) {
                this.flushBufferedMessages();
            }
        }
    }

    private void flushBufferedMessages() {
        long startLoggingTime = 0L;
        long lastLoggedTime = 0L;
        long endLoggingTime = 0L;
        long timeLoggingInterval = 100L;
        while (!this.fEventList.isEmpty()) {
            BufferedLogMessage e = this.fEventList.remove(0);
            if (startLoggingTime == 0L) {
                startLoggingTime = e.fTimestamp;
                Date date = new Date(startLoggingTime);
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
                String dateFormatted = formatter.format(date);
                this.doLog(SeverityLevel.DEBUG, kModule, "Start Log Flush t = " + dateFormatted, null, false);
            } else if (e.fTimestamp > lastLoggedTime + timeLoggingInterval) {
                lastLoggedTime = e.fTimestamp;
                long diff = lastLoggedTime - startLoggingTime;
                this.doLog(SeverityLevel.DEBUG, kModule, "Time t + " + diff + " ms", null, false);
            }
            endLoggingTime = e.fTimestamp;
            this.doLog(e.fSeverity, e.fModule, e.fMessage, e.fThrowable, false);
        }
        if (endLoggingTime != 0L) {
            long diff = endLoggingTime - startLoggingTime;
            this.doLog(SeverityLevel.DEBUG, kModule, "Flush complete t + " + diff + " ms.", null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void logbottleneck(SeverityLevel severity, Module module, String message, Throwable t) {
        Object object;
        boolean shouldLog = true;
        if (this.fShouldBuffer) {
            object = this.getFeedbackChannelLock();
            synchronized (object) {
                if (this.fShouldBuffer) {
                    this.fEventList.add(new BufferedLogMessage(severity, module, message, t));
                    shouldLog = false;
                }
            }
        }
        if (shouldLog && this.isLogEnabled(severity, module)) {
            object = this.getFeedbackChannelLock();
            synchronized (object) {
                this.doLog(severity, module, message, t, false);
            }
        }
    }

    private class BufferedLogMessage {
        public SeverityLevel fSeverity;
        public Module fModule;
        public String fMessage;
        public Throwable fThrowable;
        public long fTimestamp;

        public BufferedLogMessage(SeverityLevel severity, Module module, String message, Throwable throwable) {
            this.fSeverity = severity;
            this.fModule = module;
            this.fMessage = message;
            this.fThrowable = throwable;
            this.fTimestamp = System.currentTimeMillis();
        }
    }
}

