/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledMethod;
import java.util.HashMap;
import java.util.Map;

public final class NamedMethodMatcher
implements IMethodMatcher {
    private static final Map<String, NamedMethodMatcher> singleton = new HashMap<String, NamedMethodMatcher>();
    private final IMethodName fName;

    private NamedMethodMatcher(IMethodName name) {
        if (singleton.containsKey(name.getNameAndSignatureString())) {
            throw new RuntimeException("Instance already created");
        }
        this.fName = name;
    }

    public static NamedMethodMatcher getInstance(IMethodName name) {
        String fullName = name.getNameAndSignatureString();
        if (!singleton.containsKey(fullName)) {
            singleton.put(fullName, new NamedMethodMatcher(name));
        }
        return singleton.get(fullName);
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        boolean result = ClassFileUtilities.looselyMatches((IMethodName)this.fName, (IMethodName)method.getMethodName());
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(131072);
            current.setMethodMatchName(this.fName);
        }
        return result;
    }

    public IMethodName getMethodName() {
        return this.fName;
    }

    public String toString() {
        return "[NamedMethodMatcher: method=" + this.fName + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof NamedMethodMatcher) {
            NamedMethodMatcher matcher = (NamedMethodMatcher)o;
            return this.fName.equals(matcher.fName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

