/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.IWSNameFormatter;
import com.wily.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WSDMFaultFormatter
extends ANameFormatter
implements IWSNameFormatter,
KConstants {
    private final IAgent fAgent;

    public WSDMFaultFormatter(IAgent agent) {
        super(agent);
        this.fAgent = agent;
    }

    @Override
    public IAgent getAgent() {
        return this.fAgent;
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object o = this.getMessageContext(data);
            Class<?> cl = o.getClass();
            Method getProperty = cl.getMethod("getServiceName", new Class[0]);
            Object value = getProperty.invoke(o, new Object[0]);
            if (value != null) {
                name = WSMUtils.formatSOAPFaultURLToBeResourceSafe(value.toString());
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null || name.equals("") ? "UnknownService" : name;
    }

    @Override
    public String getNamespace(InvocationData data) {
        String name = null;
        try {
            Object o = this.getMessageContext(data);
            Class<?> cl = o.getClass();
            Method getProperty = cl.getMethod("getOperationNameSpace", new Class[0]);
            Object value = getProperty.invoke(o, new Object[0]);
            if (value != null) {
                name = WSMUtils.formatSOAPFaultURLToBeResourceSafe(value.toString());
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null || name.equals("") ? "UnknownService" : name;
    }

    protected Object getMessageContext(InvocationData data) throws RuntimeException {
        Object context = data.getInvocationParameterAsObject(0);
        return context;
    }

    protected Object getOperationDesc(InvocationData data) throws NoSuchMethodException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object context = this.getMessageContext(data);
        Object operationDesc = WSMUtils.invokeMethodOnObject(context, "getOperation");
        return operationDesc;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String name = null;
        try {
            Object o = this.getMessageContext(data);
            Class<?> cl = o.getClass();
            Method getProperty = cl.getMethod("getOperationName", new Class[0]);
            Object value = getProperty.invoke(o, new Object[0]);
            name = value.toString();
            name = WSMUtils.formatSOAPFaultURLToBeResourceSafe(name);
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", t);
        }
        return name == null || name.equals("") ? "UnknownOperationName" : name;
    }

    @Override
    public String INameFormatter_format(String name, InvocationData data) {
        String namespace = null;
        String operationName = null;
        String serviceName = null;
        if (name != null) {
            if (name.indexOf("{servicename}", 0) >= 0) {
                serviceName = this.getServiceName(data);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{namespace}", 0) >= 0) {
                namespace = this.getNamespace(data);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operationName = this.getOperationName(data);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        return name;
    }
}

