/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blamestackfeature;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blamestackfeature.AgentEventReceiver;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeatureFactory;
import com.wily.introscope.agent.blamestackfeature.IEventReceiver;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.clock.MasterClock;
import com.wily.wilyassert.Assertion;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlameStackFeatureBlameStack
implements IBlameStack {
    private Object lock = new Object();
    private BlameStackFeatureStackEntry[] stackEntries;
    private int nextIndex;
    private static final TransactionComponentData[] NoComponentDataArray = new TransactionComponentData[0];
    private WeakReference thread;
    protected IBlameStackFeature[] features;
    protected int featuresSize = 0;
    private IEventReceiver eventReceiver;

    public BlameStackFeatureBlameStack(List featureFactories) {
        this(featureFactories, AgentEventReceiver.INSTANCE);
    }

    public BlameStackFeatureBlameStack(List featureFactories, IEventReceiver eventReceiver) {
        this.eventReceiver = eventReceiver;
        this.features = new IBlameStackFeature[featureFactories.size()];
        for (IBlameStackFeatureFactory featureFactory : featureFactories) {
            this.features[this.featuresSize++] = featureFactory.newFeature(this);
        }
        this.stackEntries = new BlameStackFeatureStackEntry[10];
        for (int i = 0; i < this.stackEntries.length; ++i) {
            this.stackEntries[i] = new BlameStackFeatureStackEntry();
        }
        this.nextIndex = 0;
        this.thread = new WeakReference<Thread>(Thread.currentThread());
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_addComponent(String component) {
        Object object = this.getLock();
        synchronized (object) {
            this.push(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        Object object = this.getLock();
        synchronized (object) {
            BlameStackFeatureStackEntry newStackEntry = this.push(component);
            newStackEntry.decorate(paramName, paramValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        Object object = this.getLock();
        synchronized (object) {
            BlameStackFeatureStackEntry newStackEntry = this.push(component);
            newStackEntry.decorate(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        Object object = this.getLock();
        synchronized (object) {
            BlameStackFeatureStackEntry top = this.peek();
            if (top == null) {
                return;
            }
            top.decorate(paramName, paramValue);
        }
    }

    protected BlameStackFeatureStackEntry peek() {
        if (this.nextIndex == 0) {
            return null;
        }
        return this.stackEntries[this.nextIndex - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_removeComponent(String component) {
        Object object = this.getLock();
        synchronized (object) {
            this.pop();
        }
    }

    protected void pop() {
        if (!this.IBlameStack_isEmpty()) {
            --this.nextIndex;
        }
        if (this.nextIndex < 0) {
            AgentShim.handleError("nextIndex < 0 on thread " + Thread.currentThread().getName(), null);
            this.IBlameStack_tearDown();
            return;
        }
        BlameStackFeatureStackEntry poppedEntry = this.stackEntries[this.nextIndex];
        BlameStackFeatureStackEntry newTopEntry = this.IBlameStack_isEmpty() ? null : this.stackEntries[this.nextIndex - 1];
        for (int atFeature = 0; atFeature < this.featuresSize; ++atFeature) {
            IBlameStackFeature feature = this.features[atFeature];
            feature.onAfterPop(poppedEntry, newTopEntry);
        }
        this.stackEntries[this.nextIndex].reset();
    }

    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    public String toString() {
        return Arrays.asList(this.stackEntries).subList(0, this.nextIndex).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IBlameStack_isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.nextIndex == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_tearDown() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.features != null) {
                for (int atFeature = 0; atFeature < this.featuresSize; ++atFeature) {
                    IBlameStackFeature feature = this.features[atFeature];
                    feature.tearDown();
                }
            }
            this.nextIndex = 0;
        }
    }

    @Override
    public void setEndBoundary(String component) {
    }

    @Override
    public void setFrontBoundary(String component) {
    }

    @Override
    public boolean hasFrontBoundary() {
        return false;
    }

    @Override
    public boolean noteBoundaryError() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeAndSendSnapshot(BlameStackFeatureStackEntry poppedEntry, Map headerParams) {
        String threadGroupName;
        if (this.IBlameStack_isEmpty() && poppedEntry == null) {
            return;
        }
        if (this.thread == null || this.thread != null && (this.thread.get() == null || ((Thread)this.thread.get()).getThreadGroup() == null)) {
            return;
        }
        HashMap<String, String> rootParams = new HashMap<String, String>(headerParams);
        String threadName = InvocationData.limitSize(((Thread)this.thread.get()).getName());
        if (threadName != null) {
            rootParams.put("Thread Name", threadName);
        }
        if ((threadGroupName = InvocationData.limitSize(((Thread)this.thread.get()).getThreadGroup().getName())) != null) {
            rootParams.put("Thread Group Name", threadGroupName);
        }
        long nowRoughly = MasterClock.currentTimeMillis();
        TransactionComponentData[] kids = NoComponentDataArray;
        TransactionComponentData snapshot = null;
        Object object = this.getLock();
        synchronized (object) {
            if (poppedEntry != null) {
                TransactionComponentData data = this.nextIndex == 0 ? poppedEntry.createComponentEventData(nowRoughly, rootParams, kids) : poppedEntry.createComponentEventData(nowRoughly, null, kids);
                kids = new TransactionComponentData[]{data};
                snapshot = data;
            }
            for (int i = this.nextIndex - 1; i > 0; --i) {
                BlameStackFeatureStackEntry entry = this.stackEntries[i];
                TransactionComponentData data = entry.createComponentEventData(nowRoughly, null, kids);
                kids = new TransactionComponentData[]{data};
            }
            if (this.nextIndex != 0) {
                snapshot = this.getEarliestStackEntry().createComponentEventData(nowRoughly, rootParams, kids);
            }
        }
        if (snapshot != null) {
            this.eventReceiver.receiveSnapshot(snapshot);
        }
    }

    private BlameStackFeatureStackEntry getEarliestStackEntry() {
        return this.stackEntries[0];
    }

    public String getHeadComponentName() {
        return this.getEarliestStackEntry().getComponent();
    }

    protected BlameStackFeatureStackEntry push(String component) {
        Assertion.wilyAssert(false);
        BlameStackFeatureStackEntry newStackEntry = this.newStackEntryResizingIfNecessary(component);
        boolean reset = this.IBlameStack_isEmpty();
        for (int atFeature = 0; atFeature < this.featuresSize; ++atFeature) {
            IBlameStackFeature feature = this.features[atFeature];
            if (reset) {
                feature.reset();
            }
            feature.onBeforePush(newStackEntry);
        }
        ++this.nextIndex;
        return newStackEntry;
    }

    private BlameStackFeatureStackEntry newStackEntryResizingIfNecessary(String component) {
        if (this.nextIndex == this.stackEntries.length) {
            BlameStackFeatureStackEntry[] newStackEntries = new BlameStackFeatureStackEntry[this.stackEntries.length * 2];
            System.arraycopy(this.stackEntries, 0, newStackEntries, 0, this.stackEntries.length);
            for (int i = this.nextIndex; i < newStackEntries.length; ++i) {
                newStackEntries[i] = new BlameStackFeatureStackEntry();
            }
            this.stackEntries = newStackEntries;
        }
        BlameStackFeatureStackEntry newStackEntry = this.stackEntries[this.nextIndex];
        newStackEntry.init(component);
        return newStackEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getStackDepth() {
        Object object = this.getLock();
        synchronized (object) {
            return this.nextIndex - 1;
        }
    }

    public String getBoundaryComponent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Object object = this.getLock();
        synchronized (object) {
            try {
                if (this.thread != null && this.thread.get() != null) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug("Dumping stack for " + ((Thread)this.thread.get()).getName());
                }
                for (int i = this.nextIndex - 1; i >= 0; --i) {
                    this.stackEntries[i].dump();
                }
            }
            catch (AgentNotAvailableException e) {
                AgentShim.handleError("The unthinkable has happened", e);
            }
        }
    }

    @Override
    public String[] getDefaultBackendData() {
        return null;
    }

    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
    }

    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getComponentAt(int i) {
        Object object = this.getLock();
        synchronized (object) {
            if (i >= 0 && i < this.nextIndex) {
                return this.stackEntries[i].getComponent();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRootParameter(String key, String value) {
        Object object = this.getLock();
        synchronized (object) {
            BlameStackFeatureStackEntry root;
            if (!this.IBlameStack_isEmpty() && (root = this.stackEntries[0]) != null) {
                root.decorate(key, value);
            }
        }
    }

    @Override
    public void endBoundaryPopped(String component) {
    }

    @Override
    public void frontBoundaryPopped(String component) {
    }

    @Override
    public void addMapComponent(IStackType type, String component) {
    }

    @Override
    public void removeMapComponent(IStackType type, String component) {
    }

    @Override
    public boolean getHeadFilteringStatus() {
        return false;
    }

    @Override
    public boolean shouldCurrentTraceBePropagated() {
        return false;
    }

    @Override
    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
    }

    public void addMapComponent(IStackType type, String component, HashMap params) {
    }

    @Override
    public void popMapComponent(IStackType stackType, String component) {
    }
}

