/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.oracle;

import com.wily.introscope.agent.AgentShim;
import java.security.ProtectionDomain;
import oracle.dms.classes.ClassPreprocessor;

public final class OracleAutoProbe
implements ClassPreprocessor {
    public static final String kKey_Enable = "com.wily.introscope.probebuilder.oracle.enable";
    private final boolean fEnabled = this.calculateEnabled();
    private volatile boolean fShutdown = false;

    public OracleAutoProbe() {
        AgentShim.ProbeBuilderEntryPoint_initializeAgentShim(null);
    }

    private boolean calculateEnabled() {
        String value = System.getProperty(kKey_Enable, Boolean.TRUE.toString());
        return Boolean.valueOf(value);
    }

    private boolean isEnabled() {
        return this.fEnabled;
    }

    private boolean isShutdown() {
        return this.fShutdown;
    }

    public final byte[] processClass(String className, byte[] classBytes, int offset, int length) {
        return this.processClass(className, classBytes, offset, length, null);
    }

    public final byte[] processClass(String className, byte[] classBytes, int offset, int length, ProtectionDomain protectionDomain) {
        if (className == null || classBytes == null || offset < 0 || length < 0 || offset + length > classBytes.length) {
            return null;
        }
        byte[] original = classBytes;
        try {
            if (offset != 0 || length != classBytes.length) {
                original = new byte[length];
                System.arraycopy(classBytes, offset, original, 0, length);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return null;
        }
        if (!this.isEnabled() || this.isShutdown()) {
            return classBytes;
        }
        try {
            byte[] result = AgentShim.ProbeBuilderEntryPoint_transformClass(false, null, className, null, protectionDomain, original);
            if (result != null) {
                return result;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classBytes;
    }

    public final void destroy() {
        this.fShutdown = true;
    }
}

