/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link;

import com.wily.isengard.postofficehub.link.IRemoteClientTransport;
import com.wily.isengard.util.reflect.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;

final class TransportFactory {
    public IRemoteClientTransport newSocketTransportInstance(Object socket, int version) throws IOException {
        return this.createTransportInstance(this.getSocketTransportClassName(version), new Class[]{socket.getClass(), Integer.TYPE}, new Object[]{socket, new Integer(version)});
    }

    public IRemoteClientTransport newHttpTransportInstance(Object transportAdapter, int version) throws IOException {
        return this.createTransportInstance(this.getHttpTransportClassName(version), new Class[]{transportAdapter.getClass(), Integer.TYPE}, new Object[]{transportAdapter, new Integer(version)});
    }

    private String getSocketTransportClassName(int version) {
        return "com.wily.isengard.postofficehub.link.v1.ClientSocketTransport";
    }

    private String getHttpTransportClassName(int version) {
        return "com.wily.isengard.postofficehub.link.v1.ClientHttpTransport";
    }

    private IRemoteClientTransport createTransportInstance(String className, Class[] classParam, Object[] constructorParams) throws IOException {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor constructor = ReflectionUtils.findConstructor(clazz, classParam);
            return (IRemoteClientTransport)constructor.newInstance(constructorParams);
        }
        catch (Exception e) {
            throw new IOException("Failed to instantiate transport of type " + className + ": " + e);
        }
    }
}

