/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.errors.hc2.SoapFaultReportingTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.Map;

public class JaxWSProcessFaultTracer
extends SoapFaultReportingTracer {
    public JaxWSProcessFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected String getFaultMessage(InvocationData theData) {
        try {
            String strErrorMessage = "";
            Object objPacket1 = theData.getInvocationParameterAsObject(0);
            Field fldInvocation1 = objPacket1.getClass().getField("invocationProperties");
            Map invocationProps1 = (Map)fldInvocation1.get(objPacket1);
            String strInvocationTier = (String)invocationProps1.get("com.wily.invocation.tier");
            if (strInvocationTier == null || !strInvocationTier.equalsIgnoreCase("WEBSERVICE_SERVER")) {
                return null;
            }
            Object objPacket = theData.getInvocationReturnValueAsObject();
            Object msg = WSMUtils.invokeMethodOnObject(objPacket, "getMessage");
            boolean isFault = (Boolean)WSMUtils.invokeMethodOnObject(msg, "isFault");
            if (isFault) {
                Object objReqPacket = theData.getInvocationParameterAsObject(0);
                Field fldInvocation = objReqPacket.getClass().getField("invocationProperties");
                Map invocationProps = (Map)fldInvocation.get(objReqPacket);
                Throwable objInvocationError = (Throwable)invocationProps.get("com.wily.jaxws.weblogic.server.error");
                if (objInvocationError != null) {
                    strErrorMessage = objInvocationError.getMessage();
                }
                WSMUtils.getLogger().debug("JaxWSServerFaultTracer::faultMessage:" + strErrorMessage);
                return strErrorMessage;
            }
        }
        catch (Exception e) {
            WSMUtils.handleError(this.getAgent(), e.getMessage(), e);
        }
        return null;
    }

    @Override
    protected String getTitle() {
        return "JaxWSServerFaultTracer";
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }
}

