/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.backend.NativeFeedbackBackendFactory;
import com.wily.util.feedback.backend.NativeFeedbackBackendRegistry;
import com.wily.util.properties.IndexedProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class CoreCommonService
implements IAgentService {
    public static final String kLogBackendDefault = "com.wily.introscope.agent.feedback.backend.logback.LogbackBackendFactory";
    private IAgent fAgent;
    private static final Module kModule = new Module("AgentCoreCommon");
    private IModuleFeedbackChannel fFeedback;
    private ConfigurationWatcher fConfigurationWatcher;
    private ExtensionAdministrator fAdministrator;

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map params) {
        this.fAdministrator = (ExtensionAdministrator)params.get("ExtensionAdministrator");
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fFeedback.info(kModule, "Agent Core Common Utility Service starting");
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        String factoryClassName = props.getProperty("introscope.agent.log.backend", kLogBackendDefault);
        Class<?> clazz = null;
        NativeFeedbackBackendFactory factory = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            this.fFeedback.error("Could not load feedback backend factory:" + factoryClassName, (Throwable)e);
            return;
        }
        try {
            factory = (NativeFeedbackBackendFactory)clazz.getConstructor(IAgent.class).newInstance(agent);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.fFeedback.debug("Could not instantiate logging backend from agent constructor:" + factoryClassName, (Throwable)e);
        }
        if (factory == null) {
            try {
                factory = (NativeFeedbackBackendFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.fFeedback.debug("Could not instantiate logging backend from default constructor:" + factoryClassName, (Throwable)e);
            }
        }
        if (factory != null) {
            NativeFeedbackBackendRegistry.getInstance().registerNativeFeedbackBackendFactory(factory);
        } else {
            this.fFeedback.info("Could not instanciate logging feedback backend factory. Using default SystemOutBackend");
        }
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public Module getModule() {
        return kModule;
    }
}

