/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.adt;

import com.wily.introscope.agent.bizdef.BizDefEncapsulatedPattern;
import com.wily.util.WilyStringBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CaseSensitiveMap {
    private Map fBaseMap;
    private Map fLowercaseKeysMap;
    private Map fLowercaseKeysValuesMap;
    private Map fLowercaseValuesMap;

    private CaseSensitiveMap() {
    }

    private CaseSensitiveMap(Map baseMap) {
        this.fBaseMap = baseMap;
    }

    public static final CaseSensitiveMap getInstance(Map baseMap) {
        return new CaseSensitiveMap(baseMap);
    }

    public final Object get(String key) {
        return this.fBaseMap.get(key);
    }

    public final List get(BizDefEncapsulatedPattern name, boolean caseSensitivity, boolean lowercaseValue, Pattern patternMatcher) {
        Map dealMap = this.fBaseMap;
        ArrayList matchedKeys = null;
        if (!caseSensitivity && lowercaseValue) {
            if (this.fLowercaseKeysMap == null) {
                this.initializeLowercaseKeyMap();
            }
            dealMap = this.fLowercaseKeysMap;
        } else if (!lowercaseValue && caseSensitivity) {
            if (this.fLowercaseValuesMap == null) {
                this.initializeLowercaseValuesMap();
            }
            dealMap = this.fLowercaseValuesMap;
        } else if (!lowercaseValue && !caseSensitivity) {
            if (this.fLowercaseKeysValuesMap == null) {
                this.initializeLowercaseKeyValuesMap();
            }
            dealMap = this.fLowercaseKeysValuesMap;
        }
        for (Map.Entry entry : dealMap.entrySet()) {
            String key = entry.getKey().toString();
            Matcher matcher = patternMatcher.matcher(key);
            if (!matcher.matches()) continue;
            if (matchedKeys == null) {
                matchedKeys = new ArrayList(3);
            }
            matchedKeys.add(entry.getValue());
        }
        return matchedKeys;
    }

    public final String toString() {
        WilyStringBuilder buffer = new WilyStringBuilder();
        Iterator iter = this.fBaseMap.entrySet().iterator();
        boolean isFirst = true;
        buffer.append("{");
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            Map.Entry entry = iter.next();
            if (entry.getKey() != null) {
                buffer.append(entry.getKey() + "=");
            }
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof String) {
                buffer.append((String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof String[]) {
                buffer.append(((String[])entry.getValue())[0]);
                continue;
            }
            buffer.append(entry.getValue().toString());
        }
        buffer.append("}");
        return buffer.toString();
    }

    public final Object get(BizDefEncapsulatedPattern name, boolean caseSensitiveName) {
        if (caseSensitiveName) {
            return this.fBaseMap.get(name.getPattern());
        }
        String nameValue = name.getLowercaseOnlyPattern();
        for (Map.Entry entry : this.fBaseMap.entrySet()) {
            String key = entry.getKey().toString().toLowerCase();
            if (!key.equals(nameValue)) continue;
            return entry.getValue();
        }
        return null;
    }

    public final Object get(BizDefEncapsulatedPattern name, boolean caseSensitiveName, boolean caseSensitiveValue) {
        Map dealMap = this.fBaseMap;
        if (!caseSensitiveName) {
            if (caseSensitiveValue) {
                if (this.fLowercaseKeysMap == null) {
                    this.initializeLowercaseKeyMap();
                }
                dealMap = this.fLowercaseKeysMap;
            } else {
                if (this.fLowercaseKeysValuesMap == null) {
                    this.initializeLowercaseKeyValuesMap();
                }
                dealMap = this.fLowercaseKeysValuesMap;
            }
        } else if (!caseSensitiveValue) {
            if (this.fLowercaseValuesMap == null) {
                this.initializeLowercaseValuesMap();
            }
            dealMap = this.fLowercaseValuesMap;
        }
        String pattern = caseSensitiveName ? name.getPattern() : name.getLowercaseOnlyPattern();
        return dealMap.get(pattern);
    }

    private final void initializeLowercaseValuesMap() {
        this.fLowercaseValuesMap = new HashMap();
        for (Map.Entry entry : this.fBaseMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String lowercaseValue = null;
            if (value != null) {
                if (value instanceof String[]) {
                    lowercaseValue = ((String[])value)[0];
                    if (lowercaseValue != null) {
                        lowercaseValue = lowercaseValue.toLowerCase();
                    }
                } else if (value instanceof String) {
                    lowercaseValue = ((String)value).toLowerCase();
                }
            }
            this.fLowercaseValuesMap.put(key, lowercaseValue);
        }
    }

    private final void initializeLowercaseKeyValuesMap() {
        this.fLowercaseKeysValuesMap = new HashMap();
        for (Map.Entry entry : this.fBaseMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String lowercaseValue = null;
            if (value != null) {
                if (value instanceof String[]) {
                    lowercaseValue = ((String[])value)[0];
                    if (lowercaseValue != null) {
                        lowercaseValue = lowercaseValue.toLowerCase();
                    }
                } else if (value instanceof String) {
                    lowercaseValue = ((String)value).toLowerCase();
                }
            }
            this.fLowercaseKeysValuesMap.put(key.toLowerCase(), lowercaseValue);
        }
    }

    private final void initializeLowercaseKeyMap() {
        this.fLowercaseKeysMap = new HashMap();
        for (Map.Entry entry : this.fBaseMap.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.fLowercaseKeysMap.put(key.toLowerCase(), value);
        }
    }
}

