/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.ext.agent.threaddump;

import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.feature.StallPoint;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.threaddump.common.ThreadDumpHelper;
import com.wily.introscope.threaddump.common.WilyThreadInfo;
import com.wily.introscope.threaddump.common.WilyThreadInfoExtended;
import com.wily.util.adt.WeakIdentityKey;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.management.ThreadInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentThreadDumpHelper
extends ThreadDumpHelper {
    private static final String[] agentThreadNames = new String[]{"Deployment Watcher", "Extension Profile Watcher", "Transaction Structure Queue Execution", "Configuration Watch Heartbeat Heartbeat", "Remove Metric Data Watch Heartbeat Heartbeat", "Agent Heartbeat", "Thread Monitor Heartbeat Heartbeat", "Agent Execution", "Command Queue Heartbeat", "Agent ServerConnection", "UnknownHub Hub Transmit 1", "UnknownHub Hub Receive 1", "Temp Instrumentation Queue Heartbeat", "PO:main Mailman 1"};
    private final HashSet<String> agentThreadNameSet = new HashSet(agentThreadNames.length);
    private static final String[] agentThreadNamePrefixSet = new String[]{"Agent Extension Manager:", "PO:client_main Mailman", "agent-ii-abt-pool", "Agent DNS Service", "Agent Downstream Listener"};

    public AgentThreadDumpHelper(IModuleFeedbackChannel feedback, long maxStack) {
        super(feedback, maxStack);
        for (String s : agentThreadNames) {
            this.agentThreadNameSet.add(s);
        }
    }

    public boolean isAgentThread(String name) {
        if (this.agentThreadNameSet.contains(name)) {
            return true;
        }
        for (String p : agentThreadNamePrefixSet) {
            if (!name.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatchingState(String pattern, Thread.State state) {
        if ("ALL".equals(pattern)) {
            return true;
        }
        String stateString = AgentThreadDumpHelper.getThreadState((Thread.State)state);
        return stateString.equals(pattern);
    }

    public Map<Long, WilyThreadInfo> getThreadDump(Pattern pattern, String state, int minStack, int maxStack, boolean isInstrumented, boolean isNotInstrumented) {
        Object r;
        long[] ids = this.bean.getAllThreadIds();
        ThreadInfo[] infos = this.bean.getThreadInfo(ids);
        HashSet<Long> filteredIds = new HashSet<Long>(ids.length);
        for (ThreadInfo info : infos) {
            String name = info.getThreadName();
            Matcher m = pattern.matcher(name);
            if (!m.matches() || this.isAgentThread(name) || !this.isMatchingState(state, info.getThreadState())) continue;
            filteredIds.add(info.getThreadId());
        }
        HashMap<Long, TxnMapEntry> txnMap = new HashMap<Long, TxnMapEntry>(ids.length);
        for (Map.Entry entry : StallFeatureBase.getStallPointsEntrySet()) {
            String corid;
            String txid;
            String component;
            WeakIdentityKey key = (WeakIdentityKey)entry.getKey();
            r = (Runnable)key.get();
            if (!(r instanceof Thread)) continue;
            Thread t = (Thread)r;
            StallPoint p = (StallPoint)entry.getValue();
            IStackElement element = p.getData();
            if (!(element instanceof InvocationData)) continue;
            TxnMapEntry e = new TxnMapEntry();
            InvocationData data = (InvocationData)element;
            e.component = component = data.getFrontBoundary();
            e.txid = txid = CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot((IStackElement)element);
            e.corid = corid = CrossProcessCorrelationAdmin.getCorrelationIdFromCacheForSnapshot((IStackElement)element);
            txnMap.put(t.getId(), e);
            if (isInstrumented) continue;
            filteredIds.remove(t.getId());
        }
        if (!isNotInstrumented) {
            Iterator it = filteredIds.iterator();
            while (it.hasNext()) {
                long id = (Long)it.next();
                if (txnMap.containsKey(id)) continue;
                it.remove();
            }
        }
        HashMap<Long, WilyThreadInfo> threadMap = new HashMap<Long, WilyThreadInfo>(filteredIds.size());
        if (filteredIds.isEmpty()) {
            return threadMap;
        }
        long[] finalIds = new long[filteredIds.size()];
        int i = 0;
        r = filteredIds.iterator();
        while (r.hasNext()) {
            long id = (Long)r.next();
            finalIds[i++] = id;
        }
        this.getThreadInfo(threadMap, finalIds, false, true);
        long currentTime = System.currentTimeMillis();
        Iterator it = threadMap.keySet().iterator();
        while (it.hasNext()) {
            TxnMapEntry e;
            long id = (Long)it.next();
            WilyThreadInfoExtended info = (WilyThreadInfoExtended)threadMap.get(id);
            info.setTimestamp(currentTime);
            if (isInstrumented && (e = (TxnMapEntry)txnMap.get(id)) != null) {
                info.setTrxTraceId(e.txid);
                info.setCorrelationId(e.corid);
                info.setComponent(e.component);
            }
            if (info.getStackLen() < minStack) {
                it.remove();
                continue;
            }
            if (maxStack <= 0) continue;
            info.enforceStackTraceLength(maxStack);
        }
        return threadMap;
    }

    private static class TxnMapEntry {
        String corid;
        String txid;
        String component;
        boolean confidence;

        private TxnMapEntry() {
        }
    }
}

