/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.analysis;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.api.instrument.AClassRedefinitionDelegate;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.probebuilder.intelligent.analysis.AutoInstrumentationWorker;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.ClassMethodInfo;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.Iterator;

public class AutoInstrumentationClassReloader
implements Runnable {
    IAgent fAgent;
    ArrayList<ClassMethodInfo> fClassList;
    AutoInstrumentationWorker fAutoInstrumentationWorker;

    public AutoInstrumentationClassReloader(IAgent agent, AutoInstrumentationWorker autoInstrumentationWorker, ArrayList<ClassMethodInfo> classList) {
        this.fAgent = agent;
        this.fClassList = classList;
        this.fAutoInstrumentationWorker = autoInstrumentationWorker;
    }

    @Override
    public void run() {
        try {
            this.redefineClasses();
        }
        catch (Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error("AutoInstrumentationClassReloader failed to redefine classes! ");
            this.fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
        }
        this.fAutoInstrumentationWorker.notifyCompletedRedefinitionTask();
    }

    public void redefineClasses() {
        Iterator<ClassMethodInfo> it = this.fClassList.iterator();
        TransformerAdministrator tAdm = this.fAgent.IAgent_getTransformerAdministrator();
        AutoProbeTransformer dit = (AutoProbeTransformer)tAdm.getDynamicInstrumentationTransformer();
        Instrumentation inst = ((AClassRedefinitionDelegate)dit.getClassRedefinitionDelegate()).getInstrumentation();
        while (it.hasNext()) {
            ClassMethodInfo vg = it.next();
            try {
                this.doClassRedefinition(inst, vg.clazz);
            }
            catch (ClassNotFoundException e) {
                if (!Logger.isDebugEnabled()) continue;
                Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                if (!Logger.isDebugEnabled()) continue;
                Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
            }
            catch (UnmodifiableClassException e) {
                if (!Logger.isDebugEnabled()) continue;
                Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void doClassRedefinition(Instrumentation fInstrumentation, Class cls) throws IOException, ClassNotFoundException, UnmodifiableClassException {
        IModuleFeedbackChannel fFeedback = this.fAgent.IAgent_getModuleFeedback();
        byte[] classBytes = null;
        classBytes = ByteClassUtil.getBytesForClass((Class)cls, (int)0x100000, (IModuleFeedbackChannel)fFeedback);
        if (classBytes != null) {
            if (ByteClassUtil.byteArrayToInt((byte[])classBytes, (int)0) == -889275714) {
                ByteArrayInputStream stream = new ByteArrayInputStream(classBytes);
                ClassDefinition classDef = new ClassDefinition(cls, classBytes);
                try {
                    fInstrumentation.redefineClasses(classDef);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                fFeedback.debug("Redefined -" + cls.getName());
            }
        } else {
            fFeedback.debug("Could not obtain class bytes for the class -" + cls.getName());
        }
    }
}

