/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.connection.FailbackTask;
import com.wily.introscope.agent.connection.IServerFailoverPolicy;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.spec.server.beans.loadbalancing.AdvancedReconnectInfo;
import com.wily.introscope.spec.server.beans.loadbalancing.NoCollectorAvailableException;
import com.wily.introscope.spec.server.beans.loadbalancing.ReconnectInfo;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

class ConnectionThread
implements Runnable {
    private static final Module sModule = new Module("ConnectionThread");
    private static final int kMaxMessageCount = 10;
    private final IsengardServerConnectionManager fServerConnectionManager;
    private final IServerFailoverPolicy fFailoverPolicy;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ConfigurationManager fConfigurationManager;
    private boolean fLostConnection;
    private boolean fIsFailbackScheduled;
    private int fServerCount = 1;
    private static volatile String agentCompatibilityVersion = null;

    public ConnectionThread(IsengardServerConnectionManager connectionManager, ConfigurationManager configurationManager) {
        this.fServerConnectionManager = connectionManager;
        this.fFailoverPolicy = connectionManager.getFailoverPolicy();
        this.fFeedback = connectionManager.getFeedbackChannel();
        this.fLocalizer = connectionManager.getStringLocalizer();
        this.fConfigurationManager = configurationManager;
        ConfigurationProperty agentCompatibilityVersionProperty = new ConfigurationProperty("introscope.agent.connection.compatibility.version", null, this.fFeedback, sModule, this.fLocalizer){

            @Override
            public void set(Object value) {
                agentCompatibilityVersion = (String)value;
            }
        };
        configurationManager.add(agentCompatibilityVersionProperty, true);
        this.getFeedbackChannel().info(sModule, "introscope.agent.connection.compatibility.version is set to : " + agentCompatibilityVersion);
        this.setLostConnection(false);
    }

    @Override
    public void run() {
        boolean firstConnection = true;
        while (true) {
            this.connect(firstConnection);
            this.sendData();
            this.getServerConnectionManager().serverWentAway();
            this.setLostConnection(false);
            firstConnection = false;
        }
    }

    public synchronized void setLostConnection(boolean lostConnection) {
        this.fLostConnection = lostConnection;
    }

    public synchronized void setFailbackScheduled(boolean isScheduled) {
        this.fIsFailbackScheduled = isScheduled;
    }

    private void pauseBetweenAttempts() throws InterruptedException {
        long sleepTime = this.getFailoverPolicy().getPauseForConnectionInMillis();
        if (sleepTime != 0L) {
            Thread.sleep(sleepTime);
        }
    }

    private boolean attemptConnection(boolean firstConnectionAttempt) {
        int attemptCount = this.getFailoverPolicy().getCycleCount();
        ServerInstanceLocator serverLocator = this.getFailoverPolicy().getNextFailoverServer();
        boolean attemptSucceeded = false;
        boolean verbose = this.getFeedbackChannel().isVerboseEnabled(sModule);
        if (verbose || attemptCount <= 10) {
            this.getFeedbackChannel().verbose(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Attempt_Message", serverLocator.toString(), Integer.toString(attemptCount)));
        }
        ServerInstanceLocator locator = serverLocator;
        boolean isLoadBalanced = false;
        try {
            while (true) {
                ReconnectInfo info;
                try {
                    info = this.getServerConnectionManager().connectInternal(locator, isLoadBalanced);
                }
                catch (NoCollectorAvailableException e) {
                    this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_No_Collector_Available_Message"));
                    this.getServerConnectionManager().serverWentAway();
                    this.setLostConnection(false);
                    throw e;
                }
                if (info == null) break;
                this.getServerConnectionManager().serverWentAway();
                this.setLostConnection(false);
                ServerInstanceLocator oldLocator = locator;
                locator = ServerInstanceLocator.copyOf(info.getReconnectHost(), info.getReconnectPort(), locator);
                this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Redirected_Message", locator.toString(), oldLocator.toString()));
                isLoadBalanced = true;
            }
            this.getFailoverPolicy().notifyOfSuccessfulConnection();
            if (this.getFailoverPolicy().failbackEnabled() && !this.isFailbackScheduled()) {
                ServerInstanceLocator failbackServerLocator = this.getFailoverPolicy().getFailbackServer();
                this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Attempt_Begin_Message", Integer.toString(this.getFailoverPolicy().getFailbackRetryIntervalInSeconds())));
                IntervalHeartbeat heartbeat = AgentShim.getAgent().IAgent_getConfigHeartbeat();
                FailbackTask task = new FailbackTask(this.getFailoverPolicy(), this, this.getServerConnectionManager(), heartbeat);
                task.scheduleFailbackAttempts();
            }
            attemptSucceeded = true;
        }
        catch (Throwable t) {
            if (verbose || attemptCount <= 10) {
                String protocolFailedMessage = !firstConnectionAttempt ? "Agent_JIP_Protocol_Reconnect_Failed_Message" : "Agent_JIP_Protocol_Connect_Failed_Message";
                this.getFeedbackChannel().warn(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString(protocolFailedMessage, locator.toString(), Integer.toString(attemptCount)));
            }
            if (!verbose && attemptCount == 10) {
                String loggingStoppedMessage = !firstConnectionAttempt ? "Agent_JIP_Protocol_Reconnect_Logging_Stopped_Message" : "Agent_JIP_Protocol_Connect_Logging_Stopped_Message";
                this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString(loggingStoppedMessage));
            }
            this.getFeedbackChannel().debug(t);
            this.getFailoverPolicy().notifyOfConnectionFailure();
        }
        return attemptSucceeded;
    }

    private boolean attemptAdvancedConnection(boolean firstConnectionAttempt) {
        ServerInstanceLocator serverLocator = this.fFailoverPolicy.getNextFailoverServer();
        int cycleCount = this.fFailoverPolicy.getCycleCount();
        int attemptCount = this.fFailoverPolicy.getAttemptCount();
        boolean verbose = this.getFeedbackChannel().isVerboseEnabled(sModule);
        if (serverLocator == null) {
            try {
                if (!this.fFailoverPolicy.failbackEnabled()) {
                    this.pauseBetweenAttempts();
                }
            }
            catch (InterruptedException e) {
                this.getFeedbackChannel().trace(sModule, "ConnectionThread interrupted while pausing between connection attempts");
            }
            if (cycleCount == 1 && this.fFailoverPolicy.failbackEnabled()) {
                if (verbose || attemptCount <= 10) {
                    this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Attempt_Begin_Message", Integer.toString(this.getFailoverPolicy().getFailbackRetryIntervalInSeconds())));
                }
                try {
                    Thread.sleep(this.getFailoverPolicy().getFailbackRetryIntervalInSeconds() * 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.fFailoverPolicy.resetFailoverCounters();
            if (this.fFailoverPolicy.getAdditionalFailoverServers() != null && this.fFailoverPolicy.getAdditionalFailoverServers().getNumConnections() > 0) {
                serverLocator = this.fFailoverPolicy.getLastAvailableServer();
            }
            if (serverLocator == null) {
                cycleCount = 0;
                serverLocator = this.fFailoverPolicy.getNextFailoverServer();
            }
        }
        if (verbose || attemptCount <= 10) {
            this.getFeedbackChannel().verbose(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Attempt_Message", serverLocator.toString(), Integer.toString(attemptCount)));
        }
        try {
            if (cycleCount == 1 && this.fFailoverPolicy.failbackEnabled()) {
                this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Attempt_Begin_Message", Integer.toString(this.getFailoverPolicy().getFailbackRetryIntervalInSeconds())));
                Thread.sleep(this.getFailoverPolicy().getFailbackRetryIntervalInSeconds() * 1000);
            }
            AdvancedReconnectInfo infoList = this.getServerConnectionManager().connectInternalAdvanced(serverLocator, this.fFailoverPolicy.hasHardcodedFallbackServers());
            this.getFeedbackChannel().info(sModule, "New list " + infoList + " downloaded from " + serverLocator);
            this.fFailoverPolicy.setAttemptCount(1);
            if (this.fFailoverPolicy.setAdditionalFailoverServers(serverLocator, infoList)) {
                this.getFeedbackChannel().info("New list accepted");
                if (infoList.getNumConnections() > 0) {
                    cycleCount = 0;
                }
            }
            boolean sendData = infoList.getAllowSend();
            this.fFailoverPolicy.setLastAvailableServer(serverLocator);
            if (!sendData && infoList.getStayConnected() && !this.is10dot7CompatibilityModeEnabled()) {
                this.fFailoverPolicy.setCycleCount(1);
                this.getFeedbackChannel().info(sModule, "Connected to " + serverLocator + " in disallowed mode.");
                return true;
            }
            if (!(!sendData && cycleCount != 1 || !sendData && this.fFailoverPolicy.failbackEnabled())) {
                this.fFailoverPolicy.notifyOfSuccessfulConnection();
                if (sendData) {
                    this.getFeedbackChannel().info(sModule, "Connected to " + serverLocator + " in allowed mode.");
                } else {
                    this.fFailoverPolicy.setCycleCount(1);
                    this.getFeedbackChannel().info(sModule, "Connected to " + serverLocator + " in disallowed mode.");
                }
                return true;
            }
            this.getServerConnectionManager().serverWentAway();
            this.setLostConnection(false);
            return false;
        }
        catch (Throwable t) {
            if (verbose || attemptCount <= 10) {
                String protocolFailedMessage = !firstConnectionAttempt ? "Agent_JIP_Protocol_Reconnect_Failed_Message" : "Agent_JIP_Protocol_Connect_Failed_Message";
                String errorMsg = t.getMessage();
                String error = t.getClass().getName();
                if (errorMsg != null) {
                    error = error + ":" + errorMsg;
                }
                this.getFeedbackChannel().warn(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString(protocolFailedMessage, serverLocator.toString(), error));
            }
            if (!verbose && attemptCount == 10) {
                if (this.fServerCount == this.fFailoverPolicy.getServerCount()) {
                    String loggingStoppedMessage = !firstConnectionAttempt ? "Agent_JIP_Protocol_Reconnect_Logging_Stopped_Message" : "Agent_JIP_Protocol_Connect_Logging_Stopped_Message";
                    this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString(loggingStoppedMessage));
                    this.fServerCount = 1;
                } else {
                    ++this.fServerCount;
                }
            }
            this.getFeedbackChannel().debug(sModule, "Connection Exception: ", t);
            this.fFailoverPolicy.notifyOfConnectionFailure();
            this.fFailoverPolicy.setCycleCount(cycleCount);
            this.getServerConnectionManager().serverWentAway();
            return false;
        }
    }

    private void scheduleFailbackAttempts() throws AgentNotAvailableException {
        this.fFailoverPolicy.notifyOfSuccessfulConnection();
        if (this.fFailoverPolicy.failbackEnabled() && !this.isFailbackScheduled()) {
            ServerInstanceLocator failbackServerLocator = this.fFailoverPolicy.getFailbackServer();
            this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Attempt_Begin_Message", Integer.toString(this.getFailoverPolicy().getFailbackRetryIntervalInSeconds())));
            IntervalHeartbeat heartbeat = AgentShim.getAgent().IAgent_getConfigHeartbeat();
            FailbackTask task = new FailbackTask(this.fFailoverPolicy, this, this.getServerConnectionManager(), heartbeat);
            task.scheduleFailbackAttempts();
        }
    }

    private void connect(boolean firstConnection) {
        boolean connected = false;
        while (!connected) {
            try {
                int previousCycleCount = this.getFailoverPolicy().getCycleCount();
                try {
                    if (!this.fFailoverPolicy.failbackEnabled()) {
                        this.pauseBetweenAttempts();
                    }
                }
                catch (InterruptedException ie) {
                    this.getFeedbackChannel().trace(sModule, "ConnectionThread interrupted while pausing between connection attempts");
                }
                connected = this.attemptAdvancedConnection(firstConnection);
                int currentCycleCount = this.getFailoverPolicy().getCycleCount();
                if (currentCycleCount != 1) continue;
                this.getServerConnectionManager().tellObserversAboutFailedConnectionCycle(currentCycleCount);
                this.getFailoverPolicy().setCycleCount(previousCycleCount);
            }
            catch (Throwable t) {
                this.getFeedbackChannel().debug(sModule, "ConnectionThread caught throwable while attempting a server connection");
            }
        }
    }

    private void sendData() {
        try {
            boolean keepSending = true;
            while (keepSending && !this.lostConnection()) {
                long startTime = MasterClock.currentTimeMillis();
                keepSending = this.getServerConnectionManager().harvest();
                if (this.lostConnection()) continue;
                long sleepTime = this.getServerConnectionManager().getAgentHarvestTimeMillis() - (MasterClock.currentTimeMillis() - startTime);
                if (sleepTime < 1L) {
                    sleepTime = 1L;
                } else if (sleepTime > this.getServerConnectionManager().getAgentHarvestTimeMillis()) {
                    sleepTime = this.getServerConnectionManager().getAgentHarvestTimeMillis();
                }
                Thread.sleep(sleepTime);
            }
        }
        catch (Throwable t) {
            this.getFeedbackChannel().debug(sModule, "ConnectionThread caught throwable while sending data", t);
        }
    }

    private synchronized boolean isFailbackScheduled() {
        return this.fIsFailbackScheduled;
    }

    private synchronized boolean lostConnection() {
        return this.fLostConnection;
    }

    private IsengardServerConnectionManager getServerConnectionManager() {
        return this.fServerConnectionManager;
    }

    private IServerFailoverPolicy getFailoverPolicy() {
        return this.fFailoverPolicy;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public boolean is10dot7CompatibilityModeEnabled() {
        if (this.fConfigurationManager != null) {
            return agentCompatibilityVersion != null && agentCompatibilityVersion.startsWith("10.7");
        }
        return false;
    }
}

