/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.TimesliceAgentCommand;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.util.adt.BlockingQueue;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

class ReportingQueue
implements IServerConnectionNotification {
    private static Module sModule = new Module("ReportingQueue");
    private static final String kSizeName = "introscope.agent.reportingqueue.size";
    private static final int kSizeDefault = 100;
    private final BlockingQueue fQueue;
    private boolean fIsWaitingForInitialTimeSlice;
    private boolean fEnqueuingCommands;
    private final IStringLocalizer fLocalizer;
    private final IModuleFeedbackChannel fFeedback;
    private int fSize;

    public ReportingQueue(ConfigurationManager manager, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        this.fLocalizer = localizer;
        this.fFeedback = new DelegatingFeedbackChannel(feedback, sModule);
        this.fQueue = new BlockingQueue(sModule.getName(), this.fFeedback);
        PositiveIntegerConfigurationProperty sizeProperty = new PositiveIntegerConfigurationProperty(kSizeName, 100, this.fFeedback, sModule, localizer){

            @Override
            public void set(Object value) {
                ReportingQueue.this.fSize = (Integer)value;
            }
        };
        manager.add(sizeProperty, true);
        this.fQueue.setLimit(this.fSize);
        this.fQueue.setDebuggingFeature("com.wily.util.adt.LimitingQueue.log.drops", null, 1);
    }

    public boolean add(IAgentCommand command, IAgentBridgeService agentBridge) {
        if (this.shouldDropData(command)) {
            return false;
        }
        return this.fQueue.enqueue(command);
    }

    public boolean handleNextAgentCommand() throws Exception {
        IAgentCommand command;
        try {
            command = (IAgentCommand)this.fQueue.interruptableDequeue(1L);
        }
        catch (Exception e) {
            return false;
        }
        command.handleAgentCommand();
        return true;
    }

    public void clear() {
        this.fQueue.removeAllElements();
    }

    @Override
    public void connectionUp() {
        this.clear();
        this.setEnqueuingStartingWithInitialTimeslice();
    }

    @Override
    public void connectionDown() {
        this.setEnqueuingCommands(false);
        this.clear();
    }

    private synchronized boolean shouldDropData(IAgentCommand command) {
        boolean dropData = false;
        if (!this.isEnqueuingCommands()) {
            this.getFeedbackChannel().trace("dropping data.");
            dropData = true;
        } else if (this.isWaitingForInitialTimeSlice()) {
            if (!this.isInitialTimeslice(command)) {
                this.getFeedbackChannel().trace("dropping data: not an initial timeslice");
                dropData = true;
            } else {
                this.setFoundInitialTimeslice();
                this.clear();
                dropData = false;
            }
        }
        return dropData;
    }

    private boolean isInitialTimeslice(IAgentCommand command) {
        return command instanceof TimesliceAgentCommand && ((TimesliceAgentCommand)command).isFirstTimeslice();
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    private synchronized boolean isEnqueuingCommands() {
        return this.fEnqueuingCommands;
    }

    private synchronized void setEnqueuingStartingWithInitialTimeslice() {
        this.fIsWaitingForInitialTimeSlice = true;
        this.setEnqueuingCommands(true);
    }

    private synchronized boolean isWaitingForInitialTimeSlice() {
        return this.fIsWaitingForInitialTimeSlice;
    }

    private synchronized void setFoundInitialTimeslice() {
        this.fIsWaitingForInitialTimeSlice = false;
    }

    private synchronized void setEnqueuingCommands(boolean enqueuingCommands) {
        this.fEnqueuingCommands = enqueuingCommands;
    }
}

