/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.clamp.ASocketClampManager;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class DatagramInitClampManager
extends ASocketClampManager {
    private static final String kAddressParameterIndexKey = "addressparameterindex";
    private final int addressParamIndex = this.getIntegerParameter("addressparameterindex", 0);

    public DatagramInitClampManager(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void decideOnClamp(InvocationData data) {
        if (this.isServerSideAndNotClamped(data)) {
            return;
        }
        boolean traced = false;
        try {
            InetSocketAddress endPoint = (InetSocketAddress)data.getInvocationParameterAsObject(this.addressParamIndex);
            traced = TracedSockets.isTraced(endPoint);
            if (!traced) {
                traced = TracedSockets.add(endPoint);
            }
            if (!traced) {
                data.setSocketClamp(!traced);
            }
        }
        catch (ClassCastException cce) {
            this.getModuleFeedback().error(ASocketClampManager.kIncorrectTracerMappingErrorMsg);
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }

    private boolean isServerSideAndNotClamped(InvocationData data) {
        InetSocketAddress remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(this.addressParamIndex);
        DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
        InetSocketAddress address = DatagramChannelMap.getAddress(channel, remoteAddress);
        return address != null;
    }
}

