/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.webappsupport.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.webappsupport.AWebAppAgentNamer;
import com.wily.introscope.agent.webappsupport.weblogic.WebLogicMBeanHelper;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WebLogicAgentNamer
extends AWebAppAgentNamer {
    IModuleFeedbackChannel fFeedback = this.getAgent().IAgent_getModuleFeedback();

    public WebLogicAgentNamer(IAgent agent) {
        super(agent);
    }

    public String IAppserverEnvironmentInfoCallback_getAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String serverName = System.getProperty("weblogic.Name");
        if (StringUtils.isEmpty((String)serverName)) {
            throw new CallbackFailedTemporarilyException((ILocalizableMessage)new SimpleLocalizableMessage("WebLogic_Server_System_Property_Missing_Or_Empty_Message"));
        }
        String agentName = this.getNameFromRuntimeServiceMBean();
        if (agentName == null && (agentName = this.getNameFromMBeanHome(serverName)) == null) {
            throw new CallbackFailedTemporarilyException((ILocalizableMessage)new SimpleLocalizableMessage("Null_WebLogic_Home_MBean_And_Runtime_MBean_Server_Message"));
        }
        return agentName;
    }

    private String getNameFromMBeanHome(String serverName) throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String domainName = null;
        String clusterName = null;
        Object home = WebLogicMBeanHelper.getMBeanHome();
        if (home == null) {
            return null;
        }
        domainName = this.getDomainName(home);
        clusterName = this.getClusterName(home, serverName);
        return StringUtils.concatAndEscapeStrings((String)domainName, (String)clusterName, (String)serverName, (char)'/', (char)'_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameFromRuntimeServiceMBean() {
        InitialContext context = null;
        MBeanServer resultServer = null;
        String serverName = null;
        String domainName = null;
        String clusterName = null;
        String resultName = null;
        try {
            context = new InitialContext();
            resultServer = (MBeanServer)context.lookup("java:comp/jmx/runtime");
            if (resultServer == null) {
                throw new CallbackFailedTemporarilyException((ILocalizableMessage)new SimpleLocalizableMessage("Null_WebLogic_Runtime_MBean_Server_Message"));
            }
            ObjectName rs = new ObjectName("com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean");
            serverName = (String)resultServer.getAttribute(rs, "ServerName");
            this.fFeedback.debug("WLAN: server name = -->" + (serverName == null ? "null" : serverName) + "<--");
            ObjectName domainMBean = (ObjectName)resultServer.getAttribute(rs, "DomainConfiguration");
            domainName = (String)resultServer.getAttribute(domainMBean, "Name");
            this.fFeedback.debug("WLAN: domain name = -->" + (domainName == null ? "null" : domainName) + "<--");
            ObjectName serverMBeanON = (ObjectName)resultServer.getAttribute(rs, "ServerConfiguration");
            ObjectName clusterMBeanON = (ObjectName)resultServer.getAttribute(serverMBeanON, "Cluster");
            if (clusterMBeanON != null) {
                clusterName = (String)resultServer.getAttribute(clusterMBeanON, "Name");
                this.fFeedback.debug("WLAN: cluster name = -->" + (clusterName == null ? "null" : clusterName) + "<--");
            } else {
                this.fFeedback.debug("cluster name is null");
            }
            resultName = StringUtils.concatAndEscapeStrings((String)domainName, (String)clusterName, (String)serverName, (char)'/', (char)'_');
            this.fFeedback.debug("WLAN: result name = -->" + (resultName == null ? "null" : resultName) + "<--");
        }
        catch (Exception e) {
            this.fFeedback.debug("caught exception trying to determine agent name.", (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    this.fFeedback.debug("could not close context.", (Throwable)e);
                }
            }
        }
        return resultName;
    }

    private String getClusterName(Object mBeanHome, String serverName) throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String kGetNameMethodName = "getName";
        String kAdminClassName = "weblogic.management.Admin";
        String kGetInstanceMethodName = "getInstance";
        String kGetClusterMethodName = "getCluster";
        String kGetLocalServerMethodName = "getLocalServer";
        try {
            Class<?> adminClass = Class.forName("weblogic.management.Admin");
            if (adminClass == null) {
                return null;
            }
            Method getInstanceMethod = adminClass.getMethod("getInstance", new Class[0]);
            if (getInstanceMethod == null || !Modifier.isStatic(getInstanceMethod.getModifiers())) {
                return null;
            }
            Object adminObj = getInstanceMethod.invoke(null, new Object[0]);
            if (adminObj == null) {
                return null;
            }
            Class<?> adminObjClass = adminObj.getClass();
            if (adminObjClass == null) {
                return null;
            }
            Method getLocalServerMethod = adminObjClass.getMethod("getLocalServer", new Class[0]);
            if (getLocalServerMethod == null || Modifier.isStatic(getLocalServerMethod.getModifiers())) {
                return null;
            }
            Object serverMBeanObject = getLocalServerMethod.invoke(adminObj, new Object[0]);
            if (serverMBeanObject == null) {
                return null;
            }
            Class<?> serverMBeanClass = serverMBeanObject.getClass();
            if (serverMBeanClass == null) {
                return null;
            }
            Method getClusterMethod = serverMBeanClass.getMethod("getCluster", new Class[0]);
            if (getClusterMethod == null || Modifier.isStatic(getClusterMethod.getModifiers())) {
                return null;
            }
            Object clusterObject = getClusterMethod.invoke(serverMBeanObject, new Object[0]);
            if (clusterObject == null) {
                return null;
            }
            Class<?> clusterClass = clusterObject.getClass();
            if (clusterClass == null) {
                return null;
            }
            Method getNameMethod = clusterClass.getMethod("getName", new Class[0]);
            if (getNameMethod == null || Modifier.isStatic(getNameMethod.getModifiers())) {
                return null;
            }
            String clusterName = (String)getNameMethod.invoke(clusterObject, new Object[0]);
            return clusterName;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (Exception e) {
            this.fFeedback.warn("caught exception trying to determine cluster name.", (Throwable)e);
            return null;
        }
    }

    private String getDomainName(Object home) throws CallbackFailedPermanentlyException {
        Method getNameMethod;
        Method getActiveDomainMethod;
        String kGetActiveDomainMethodName = "getActiveDomain";
        String kGetNameMethodName = "getName";
        if (home == null) {
            return null;
        }
        Class<?> homeClass = home.getClass();
        try {
            getActiveDomainMethod = homeClass.getMethod("getActiveDomain", new Class[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (getActiveDomainMethod == null || Modifier.isStatic(getActiveDomainMethod.getModifiers())) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new SimpleLocalizableMessage("MBean_Home_Get_Active_Domain_Method_Not_Found_Message"));
        }
        Object domainObject = null;
        try {
            domainObject = getActiveDomainMethod.invoke(home, new Object[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (domainObject == null) {
            return null;
        }
        Class<?> domainClass = domainObject.getClass();
        if (domainClass == null) {
            return null;
        }
        try {
            getNameMethod = domainClass.getMethod("getName", new Class[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (getNameMethod == null || Modifier.isStatic(getNameMethod.getModifiers())) {
            return null;
        }
        Object nameObj = null;
        try {
            nameObj = getNameMethod.invoke(domainObject, new Object[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (nameObj == null || !(nameObj instanceof String)) {
            return null;
        }
        return (String)nameObj;
    }
}

