/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.wldf.AWLDFDataView;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class IntWLDFDataView
extends AWLDFDataView {
    private IIntegerFluctuatingCounterDataAccumulator fAccumulator;
    private String fullMetricName;

    public IntWLDFDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        super(agent, on, server, attributeName);
        this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createIntegerFluctuatingCounterDataAccumulator(fullIntroscopeMetricName);
        this.fullMetricName = fullIntroscopeMetricName;
    }

    @Override
    protected void doUpdate(Object currentValue) {
        boolean shouldUpdate = false;
        int intValue = 0;
        if (currentValue instanceof Number) {
            Number numberValue = (Number)currentValue;
            intValue = numberValue.intValue();
            shouldUpdate = true;
        } else if (currentValue instanceof String) {
            try {
                intValue = Integer.parseInt((String)currentValue);
                shouldUpdate = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (shouldUpdate) {
            this.fAccumulator.IIntegerCounterDataAccumulator_setValue(intValue);
        }
    }

    @Override
    protected IDataAccumulator getAccumulator() {
        return this.fAccumulator;
    }

    @Override
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        finally {
            this.fAccumulator = null;
        }
    }

    @Override
    public String getFullMetricName() {
        return this.fullMetricName;
    }
}

