/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.service.subscription.stream;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.service.MessageService;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.messageprimitives.stream.StreamSpecifier;
import com.wily.isengard.ongoingquery.QuerySyntaxException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.service.subscription.stream.IStreamSubscription;
import com.wily.isengard.service.subscription.stream.IStreamSubscriptionService;
import com.wily.util.exception.UnexpectedExceptionError;

public abstract class AStreamSubscription
extends MessageService
implements IStreamSubscription {
    private final String fPattern;

    public AStreamSubscription(PostOffice po, String matchingPattern) {
        super(po);
        try {
            this.initialize(IStreamSubscription.class, this);
        }
        catch (InvalidIsengardInterface e) {
            throw new UnexpectedExceptionError(e);
        }
        this.fPattern = matchingPattern.charAt(0) == '/' ? "/stream" + matchingPattern : "/stream/" + matchingPattern;
    }

    public void removeSubscription() {
        try {
            IStreamSubscriptionService client = MessageServiceFactory.getService(this.getPostOffice(), IStreamSubscriptionService.class);
            client.unsubscribeToStream(this.getAddress());
        }
        catch (ConnectionException connectionException) {
        }
        catch (ServiceException serviceException) {}
    }

    protected abstract void newStreamAvailable(StreamSpecifier var1, RegistryEntry var2);

    protected abstract void streamWentAway(StreamSpecifier var1, RegistryEntry var2);

    @Override
    public final void StreamAvailable(String streamName, RegistryEntry properties) {
        this.newStreamAvailable(new StreamSpecifier(streamName, properties.getAddress()), properties);
    }

    @Override
    public final void StreamUnavailable(String streamName, RegistryEntry properties) {
        this.streamWentAway(new StreamSpecifier(streamName, properties.getAddress()), properties);
    }

    protected void activateSubscription() throws QuerySyntaxException, ConnectionException {
        IStreamSubscriptionService client;
        try {
            client = MessageServiceFactory.getService(this.getPostOffice(), IStreamSubscriptionService.class);
        }
        catch (ServiceException e) {
            throw new UnexpectedExceptionError(e);
        }
        client.subscribeToStream(this.fPattern, this.getAddress());
    }

    public static IStreamSubscription getInterface(PostOffice po, Address address) {
        return MessageServiceFactory.getService(po, IStreamSubscription.class, address);
    }
}

