/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.springboot.actuator;

import com.ca.apm.agent.jmxclient.api.JmxMetricInfo;
import com.ca.apm.agent.jmxclient.metrics.ListenerFactoriesRepo;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActuatorAdapter<R, T>
implements MetricValueListener<R> {
    private Map<String, MetricValueListener<T>> metricListeners;
    private final String rootMetricName;
    private List<String> springbootThreads;

    public ActuatorAdapter(String rootMetricName, JmxMetricInfo jmxMetricInfo) {
        this.rootMetricName = rootMetricName;
        this.metricListeners = new HashMap<String, MetricValueListener<T>>();
        this.springbootThreads = jmxMetricInfo.getConfigThreads();
    }

    @Override
    public void update(R value) {
        block11: {
            block10: {
                if (!(value instanceof Map)) break block10;
                for (Object key : ((Map)value).keySet()) {
                    MetricValueListener<Object> delagate = this.metricListeners.get(key);
                    Object val = ((Map)value).get(key);
                    if (delagate == null) {
                        String metricName = this.rootMetricName + ":" + key;
                        delagate = ListenerFactoriesRepo.FLUCTUATING_COUNTER_FACTORY.createMetricListener(metricName);
                        this.metricListeners.put((String)key, delagate);
                    }
                    delagate.update(val);
                }
                break block11;
            }
            if (!(value instanceof ArrayList)) break block11;
            for (Object item : (ArrayList)value) {
                if (!(item instanceof Map)) continue;
                String threadName = "";
                String prettyName = "";
                for (Object name : ((Map)item).keySet()) {
                    if (((String)name).equalsIgnoreCase("threadName")) {
                        threadName = (String)((Map)item).get(name);
                        prettyName = threadName.replace('#', '_');
                        prettyName = prettyName.replace('|', '_');
                        prettyName = prettyName.replace(':', '_');
                        continue;
                    }
                    if (!this.springbootThreads.isEmpty() && !this.springbootThreads.contains(threadName)) continue;
                    Object keyVal = ((Map)item).get(name);
                    MetricValueListener<Object> delagate = this.metricListeners.get(prettyName + name);
                    if (delagate == null) {
                        if (prettyName.equals("")) {
                            prettyName = "UnknownThread";
                        }
                        String metricName = this.rootMetricName + "|" + prettyName + ":" + name;
                        if (keyVal instanceof String) {
                            delagate = ListenerFactoriesRepo.STRING_FACTORY.createMetricListener(metricName);
                            keyVal = ((String)keyVal).replace('#', '_');
                        } else if (keyVal instanceof Long) {
                            delagate = ListenerFactoriesRepo.FLUCTUATING_COUNTER_FACTORY.createMetricListener(metricName);
                        }
                        this.metricListeners.put(prettyName + name, delagate);
                    }
                    if (delagate == null) continue;
                    delagate.update(keyVal);
                }
            }
        }
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Map || value instanceof ArrayList;
    }

    @Override
    public void close() {
        for (MetricValueListener<T> delagate : this.metricListeners.values()) {
            delagate.close();
        }
    }
}

