/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Map;

public class InvocationContextNameformatter
implements INameFormatter,
KConstants {
    protected final IAgent fAgent;
    protected IModuleFeedbackChannel logger;

    public InvocationContextNameformatter(IAgent agent) {
        this.fAgent = agent;
        this.logger = this.fAgent.IAgent_getModuleFeedback();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        if (name == null) {
            return null;
        }
        try {
            String operationName = "UnknownOperationName";
            String serviceName = "UnknownService";
            String namespace = "UnknownNamespace";
            Object objInvocationContext = data.getInvocationParameterAsObject(0);
            Object objMessageContext = WSMUtils.invokeMethodOnObject(objInvocationContext, "getRequestMessageContext");
            Map mapRequestContext = (Map)WSMUtils.invokeMethodOnObject(objMessageContext, "getProperties");
            this.logger.debug("InvocationContextNameformatter.INameFormatter_format()..mapRequestContext is:" + mapRequestContext);
            serviceName = (String)mapRequestContext.get("javax.xml.ws.service.endpoint.address");
            namespace = (String)mapRequestContext.get("com.wily.powerpack.jaxws.client.was7.namespace");
            operationName = (String)mapRequestContext.get("com.wily.powerpack.jaxws.client.was7.operation");
            if (name.indexOf("{namespace}", 0) >= 0) {
                if (namespace == null) {
                    namespace = serviceName;
                }
                if (namespace == null) {
                    namespace = "UnknownNamespace";
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                if (serviceName == null) {
                    serviceName = "UnknownService";
                }
                serviceName = WSMUtils.formatToBeResourceSafe(serviceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                if (operationName == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
        return name;
    }
}

