/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.powerpack.webservices.JAXWSUtils;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.hc2.WebServiceBlamePointTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class AsyncFaultTracer
extends WebServiceBlamePointTracer {
    protected IModuleFeedbackChannel logger = null;

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
        String faultErrorMessage;
        boolean isOperation = (Boolean)data.get("isOperation");
        if (data.hasInvocationThrownException()) {
            Throwable error = data.getInvocationThrownException();
            String component = data.getComponentName();
            String errorMessage = component + ": " + error.getClass().getName() + ": " + error.getMessage();
            ErrorFeature.incrementErrorMetric((IStackElement)data);
            if (isOperation) {
                ErrorFeature.constructAndSendErrorSnapshotToServer((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent());
                ErrorFeature.decorateTransactionsWithError((InvocationData)data, (String)errorMessage);
            }
        }
        if ((faultErrorMessage = (String)data.get("faultErrorMessage")) != null && !faultErrorMessage.equals("")) {
            FaultFeature.incrementFaultMetric((InvocationData)data);
            if (isOperation) {
                this.reportFault("SOAP Fault:" + faultErrorMessage, data);
            }
        }
    }

    public AsyncFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    protected String getFaultMessage(InvocationData theData) {
        String faultMessage = "";
        try {
            Throwable objError = (Throwable)theData.getInvocationParameterAsObject(1);
            Map mapResponseCtx = JAXWSUtils.get();
            Boolean objSoapFaultExists = (Boolean)mapResponseCtx.get("com.wily.message.fault");
            if (objSoapFaultExists != null && objSoapFaultExists.booleanValue() && objError != null) {
                faultMessage = objError.getCause().getMessage();
                WSMUtils.getLogger().debug("AsyncFaultTracer::FAULT CAUSE:" + faultMessage);
            }
            return faultMessage;
        }
        catch (Exception e) {
            WSMUtils.handleError(this.getAgent(), e.getMessage(), e);
            return null;
        }
    }

    protected String getTitle() {
        return "AsyncFaultTracer";
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finished SOAP Fault Trace:" + this.getTitle());
        }
        String faultErrorMessage = this.getFaultMessage(data);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Fault Error message:" + faultErrorMessage);
        }
        data.put("faultErrorMessage", (Object)faultErrorMessage);
        String component = this.getFormattedName();
        this.logger.debug("AsyncFaultTracer::component:" + component);
        int nOperationIndex = component.indexOf("{operationname}");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.getTitle() + "_finishTrace nOperationIndex= " + nOperationIndex + " component=" + component);
        }
        if (nOperationIndex != -1) {
            data.put("isOperation", (Object)true);
        }
        super.ITracer_finishTrace(index, data);
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Started SOAP Fault Trace:" + this.getTitle());
        }
        super.doStartBlamePointTrace(index, data);
    }

    protected void reportFault(String message, InvocationData data) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getTitle() + " reportFault message " + message);
            }
            FaultFeature.constructAndSendFaultSnapshotToServer((InvocationData)data, (String)message, (IAgent)this.getAgent());
            FaultFeature.decorateTransactionsWithFault((InvocationData)data, (String)message);
        }
        catch (Throwable t) {
            this.logger.debug(this.getTitle() + " reportFault throwable" + t);
        }
    }
}

