/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class ClientAsyncFaultTracer
extends ASingleInstanceTracerFactory {
    protected final IModuleFeedbackChannel logger;
    private DataAccumulatorFactory factory;

    public ClientAsyncFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("START:ClientAsyncFaultTracer.ITracer_finishTrace()");
        }
        try {
            String faultMessage;
            boolean errSnap;
            Boolean isFault;
            Throwable error = (Throwable)data.getInvocationParameterAsObject(0);
            Object objCoreMessageContext = data.getInvocationParameterAsObject(1);
            Object objAxisMessageContext = WSMUtils.invokeMethodOnObject(objCoreMessageContext, "getAxisMessageContext");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("objAxisMessageContext:" + objAxisMessageContext);
            }
            if ((isFault = (Boolean)WSMUtils.invokeMethodOnObject(objAxisMessageContext, "isFault")) != null && isFault.booleanValue() && (errSnap = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)(faultMessage = "SOAP Fault:: " + error.toString())))) {
                try {
                    String name = this.formatParameterizedName(data);
                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (ESEException e) {
                    Assertion.wilyFail((String)"Metric type conflict");
                }
            }
            String component = this.formatParameterizedResource(data);
            this.getComponentTracer().removeComponent(component);
        }
        catch (Exception exFault) {
            this.logger.error((Throwable)exFault);
        }
        this.logger.debug("END:ClientAsyncFaultTracer.ITracer_finishTrace()");
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        String component = this.formatParameterizedResource(data);
        this.getComponentTracer().addComponent(component);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

