/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.Statement;

public class ResultSetToSQLMappingTracer
extends ASingleInstanceTracerFactory {
    private static final int kMapCount = 32;
    private static final int kMapBitField = 31;
    private static final WeakIdentityHashMap[] sResultSetMaps;
    private static ThreadLocal threadLocalMap;

    public ResultSetToSQLMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        long generatedTime = data.getWallClockFinishTime();
        Object resultSet = data.getInvocationReturnValueAsObject();
        if (resultSet == null) {
            return;
        }
        if (!(resultSet instanceof ResultSet)) {
            return;
        }
        Object statement = data.getInvocationObject();
        if (statement == null || !(statement instanceof Statement)) {
            Assertion.wilyAssert((String)"expected a Statement");
            return;
        }
        String sql = this.getCreationSQL((Statement)statement, data);
        String type = this.getCreationSQLType((Statement)statement);
        if (sql != null && type != null) {
            this.putInMaps(resultSet, sql, type, generatedTime, statement);
        }
    }

    private void putInMaps(Object resultSetObject, String sql, String type, long generatedTime, Object stmtObject) {
        ResultSetCreationRecord rec = new ResultSetCreationRecord(sql, type, generatedTime, stmtObject);
        ResultSetToSQLMappingTracer.putInStaticMap(resultSetObject, rec);
        WeakIdentityHashMap tlMap = (WeakIdentityHashMap)threadLocalMap.get();
        tlMap.put(resultSetObject, (Object)rec);
    }

    private static int getIndex(Object key) {
        return key.hashCode() & 0x1F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInStaticMap(Object key, Object value) {
        WeakIdentityHashMap map;
        WeakIdentityHashMap weakIdentityHashMap = map = sResultSetMaps[ResultSetToSQLMappingTracer.getIndex(key)];
        synchronized (weakIdentityHashMap) {
            map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFromStaticMap(Object key) {
        WeakIdentityHashMap map;
        WeakIdentityHashMap weakIdentityHashMap = map = sResultSetMaps[ResultSetToSQLMappingTracer.getIndex(key)];
        synchronized (weakIdentityHashMap) {
            return map.get(key);
        }
    }

    private static ResultSetCreationRecord getFromMaps(Object key) {
        WeakIdentityHashMap tlMap = (WeakIdentityHashMap)threadLocalMap.get();
        Object val = tlMap.get(key);
        if (val == null && (val = ResultSetToSQLMappingTracer.getFromStaticMap(key)) != null) {
            tlMap.put(key, val);
        }
        return (ResultSetCreationRecord)val;
    }

    protected String getCreationSQLType(Statement statement) {
        return StatementToSQLMappingTracer.getSQLType(statement);
    }

    protected String getCreationSQL(Statement statement, InvocationData data) {
        String sql = (String)data.get("com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache");
        if (sql == null && (sql = StatementToSQLMappingTracer.getSQL(statement)) != null) {
            data.put("com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache", (Object)sql);
        }
        return sql;
    }

    public static String getSQL(ResultSet resultSet) {
        ResultSetCreationRecord record;
        if (resultSet != null && (record = ResultSetToSQLMappingTracer.getFromMaps(resultSet)) != null) {
            return record.fSQL;
        }
        return null;
    }

    public static Object getStatement(Object resultSet) {
        ResultSetCreationRecord rec = ResultSetToSQLMappingTracer.getFromMaps(resultSet);
        Object result = null;
        if (rec != null) {
            result = rec.fStatement.get();
        }
        return result;
    }

    public static long getGeneratedTime(ResultSet resultSet) {
        ResultSetCreationRecord record;
        if (resultSet != null && (record = ResultSetToSQLMappingTracer.getFromMaps(resultSet)) != null) {
            return record.getStartTime();
        }
        return 0L;
    }

    public static String getSQLType(ResultSet resultSet) {
        ResultSetCreationRecord record;
        if (resultSet != null && (record = ResultSetToSQLMappingTracer.getFromMaps(resultSet)) != null) {
            return record.fSQLType;
        }
        return null;
    }

    public static ResultSetCreationRecord getRecord(ResultSet resultSet) {
        ResultSetCreationRecord record;
        if (resultSet != null && (record = ResultSetToSQLMappingTracer.getFromMaps(resultSet)) != null) {
            return record;
        }
        return null;
    }

    static {
        threadLocalMap = new ThreadLocal(){

            protected Object initialValue() {
                return new WeakIdentityHashMap();
            }
        };
        sResultSetMaps = new WeakIdentityHashMap[32];
        for (int i = 0; i < 32; ++i) {
            ResultSetToSQLMappingTracer.sResultSetMaps[i] = new WeakIdentityHashMap();
        }
    }

    public static final class ResultSetCreationRecord {
        private final String fSQL;
        private final String fSQLType;
        private final long fStartTime;
        final WeakReference fStatement;

        public ResultSetCreationRecord(String sql, String type, long time, Object stmt) {
            this.fSQL = sql;
            this.fSQLType = type;
            this.fStartTime = time;
            this.fStatement = new WeakReference<Object>(stmt);
        }

        public String toString() {
            return "[ResultSetCreationRecord: SQL=" + this.getSQL() + ", type=" + this.getSQLType() + ", time=" + this.getStartTime() + ", statement=" + this.fStatement + "]";
        }

        public String getSQL() {
            return this.fSQL;
        }

        public String getSQLType() {
            return this.fSQLType;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public Statement getStatement() {
            Object result = this.fStatement.get();
            if (result != null && result instanceof Statement) {
                return (Statement)result;
            }
            Assertion.wilyAssert((String)"expected a Statement");
            return null;
        }
    }
}

