/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.util.WilyStringBuilder;

public final class SQLTokenizer {
    public static final int kTokenType_None = -1;
    public static final int kTokenType_Character = 0;
    public static final int kTokenType_Word = 1;
    public static final int kTokenType_Number = 2;
    public static final int kTokenType_QuotedString = 3;
    public static final int kTokenType_EndOfString = 4;
    private static final int kTokenType_Whitespace = 5;
    private static final int kTokenType_Digit = 6;
    private static final int kTokenType_NonDigitNumber = 7;
    public static final int kTokenType_OpenParenthesis = 10;
    public static final int kTokenType_CloseParenthesis = 11;
    public static final int kTokenType_QuestionMark = 12;
    public static final int kTokenType_Comma = 13;
    public static final int kTokenType_ResourceSeparator = 14;
    public static final int kTokenType_MetricSeparator = 15;
    public static final int kTokenType_AtSign = 16;
    private static final byte[] fCharacterType;
    private char[] fSource;
    private int fSrcLen;
    private int fStartIndex;
    private int fEndIndex;

    public SQLTokenizer(String source) {
        this.initialize(source);
    }

    public SQLTokenizer() {
    }

    public void initialize(String source) {
        this.fSrcLen = source.length();
        if (this.fSource == null || this.fSource.length < this.fSrcLen) {
            this.fSource = new char[this.fSrcLen];
        }
        source.getChars(0, this.fSrcLen, this.fSource, 0);
        this.fStartIndex = -1;
        this.fEndIndex = -1;
    }

    private char getChar(int index) {
        return this.fSource[index];
    }

    private int getType(char ch) {
        return ch < '\u0100' ? fCharacterType[ch] : 1;
    }

    private boolean isDigit(char ch) {
        return this.getType(ch) == 6;
    }

    public void appendCurrentTextToBuffer(StringBuffer buffer) {
        for (int i = this.fStartIndex; i <= this.fEndIndex; ++i) {
            buffer.append(Character.toUpperCase(this.getChar(i)));
        }
    }

    public void appendCurrentTextToBuffer(WilyStringBuilder buffer) {
        for (int i = this.fStartIndex; i <= this.fEndIndex; ++i) {
            buffer.append(Character.toUpperCase(this.getChar(i)));
        }
    }

    public char getCurrentCharacter() {
        return Character.toUpperCase(this.getChar(this.getStartIndex()));
    }

    public int getStartIndex() {
        return this.fStartIndex;
    }

    public int getEndIndex() {
        return this.fEndIndex;
    }

    public int getNextTokenType() {
        int size = this.fSrcLen;
        if (this.fEndIndex == size) {
            return 4;
        }
        this.fStartIndex = this.fEndIndex + 1;
        block6: while (this.fStartIndex < size) {
            char ch = this.getChar(this.fStartIndex);
            int tokenType = this.getType(ch);
            switch (tokenType) {
                case 5: {
                    ++this.fStartIndex;
                    continue block6;
                }
                case 6: 
                case 7: {
                    return this.handleNumber(ch, size);
                }
                case 3: {
                    return this.handleQuotedString(ch, size);
                }
                case 1: {
                    return this.handleWord(ch, size);
                }
            }
            this.fEndIndex = this.fStartIndex;
            return tokenType;
        }
        this.fEndIndex = this.fStartIndex;
        return 4;
    }

    private int handleNumber(char ch, int size) {
        boolean seenDecimalPoint = false;
        int index = this.fStartIndex + 1;
        if (index == size) {
            this.fEndIndex = this.fStartIndex;
            if (ch == '-' || ch == '.') {
                return 0;
            }
            return 2;
        }
        char ch2 = this.getChar(index);
        if (ch == '-') {
            if (ch2 != '.' && !this.isDigit(ch2)) {
                this.fEndIndex = this.fStartIndex;
                return 0;
            }
        } else if (ch == '.') {
            if (!this.isDigit(ch2)) {
                if (ch2 == '.') {
                    char ch3 = this.getChar(index + 1);
                    if (ch3 == '.') {
                        this.fEndIndex = this.fStartIndex + 2;
                        return 1;
                    }
                } else if (!this.isDigit(ch2)) {
                    this.fEndIndex = this.fStartIndex;
                    return 0;
                }
            }
            seenDecimalPoint = true;
        } else if (ch == '0' && (ch2 == 'x' || ch2 == 'X')) {
            if (index + 1 == size) {
                this.fEndIndex = index - 1;
                return 2;
            }
            ch2 = this.getChar(++index);
            while ((this.isDigit(ch2) || ch2 >= 'A' && ch2 <= 'F' || ch2 >= 'a' && ch2 <= 'f') && ++index != size) {
                ch2 = this.getChar(index);
            }
            this.fEndIndex = index - 1;
            return 2;
        }
        while (this.isDigit(ch2) || ch2 == '.' && !seenDecimalPoint) {
            if (ch2 == '.') {
                seenDecimalPoint = true;
            }
            if (++index == size) break;
            ch2 = this.getChar(index);
        }
        this.fEndIndex = index - 1;
        return 2;
    }

    private int handleQuotedString(char ch, int size) {
        int index = this.fStartIndex + 1;
        if (index == size) {
            this.fEndIndex = this.fStartIndex;
            return 3;
        }
        char ch2 = ch;
        while (index < size) {
            ch2 = this.getChar(index);
            if (ch2 == '\\' && index < size - 1) {
                ++index;
            }
            if (ch2 == ch && index < size - 1 && (ch2 = this.getChar(++index)) != ch) break;
            ++index;
        }
        this.fEndIndex = ch2 == ch ? index : index - 1;
        return 3;
    }

    private int handleWord(char ch, int size) {
        int index;
        block3: for (index = this.fStartIndex + 1; index < size; ++index) {
            switch (this.getType(this.getChar(index))) {
                case 1: 
                case 6: 
                case 7: {
                    continue block3;
                }
            }
            this.fEndIndex = index - 1;
            return 1;
        }
        this.fEndIndex = index - 1;
        return 1;
    }

    static {
        int i;
        fCharacterType = new byte[256];
        for (i = 97; i <= 122; ++i) {
            SQLTokenizer.fCharacterType[i] = 1;
        }
        for (i = 65; i <= 90; ++i) {
            SQLTokenizer.fCharacterType[i] = 1;
        }
        for (i = 160; i <= 255; ++i) {
            SQLTokenizer.fCharacterType[i] = 1;
        }
        SQLTokenizer.fCharacterType[95] = 1;
        SQLTokenizer.fCharacterType[34] = System.getProperty("SQLAgentNormalizeDoubleQuoteString") != null ? 3 : 1;
        SQLTokenizer.fCharacterType[39] = 3;
        for (i = 48; i <= 57; ++i) {
            SQLTokenizer.fCharacterType[i] = 6;
        }
        SQLTokenizer.fCharacterType[45] = 7;
        SQLTokenizer.fCharacterType[46] = 7;
        for (i = 0; i <= 32; ++i) {
            SQLTokenizer.fCharacterType[i] = 5;
        }
        SQLTokenizer.fCharacterType[40] = 10;
        SQLTokenizer.fCharacterType[41] = 11;
        SQLTokenizer.fCharacterType[63] = 12;
        SQLTokenizer.fCharacterType[44] = 13;
        SQLTokenizer.fCharacterType[64] = 16;
        SQLTokenizer.fCharacterType[124] = 14;
        SQLTokenizer.fCharacterType[58] = 15;
    }
}

