/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.StatementNormalizer;
import com.wily.introscope.agent.sqlagent.WrappedObjectToWrapperMappingTracer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.adt.IAgedMap;
import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.IWeakMap;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.wilyassert.Assertion;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class StatementToSQLMappingTracer
extends ASingleInstanceTracerFactory
implements ICacheableInvocationDataTracerFactory {
    public static Module module = new Module("StatementToSQLMappingTracer");
    private static IModuleFeedbackChannel fFeedback;
    private static final int kMapCount = 32;
    private static final int kMapBitField = 31;
    private static final IWeakIdentityMap concStatementToSQL;
    private static final IWeakIdentityMap concPrepNCallableStmtToSQL;
    private static int prepNCallableStmtMaxSize;
    private static final IWeakMap concRawToNorm;
    private static final IWeakIdentityMap concStatementToBlameKey;
    private static final WeakIdentityHashMap[] sStatementToSQLMaps;
    private static final ThreadLocal sStatementToSQLThreadLocal;
    private static final WeakHashMap[] sRawToNormalizedSQLMaps;
    private static final ThreadLocal sRawToNormalizedSQLThreadLocal;
    private static final Map sStatementTypeMap;
    private static SQLAgentConfiguration fConfiguration;
    private static final IGuaranteedCounter sNormalizerConfigCounter;
    public static final String kSQLParameterIndexKey = "sqlparameterindex";
    private final int sqlParameterIndex = this.getIntegerParameter("sqlparameterindex", 0);
    private static long lastMessageDisplayTime;
    private static final long MIN_TIME_GAP_BETWEEN_MESSAGES = 600000L;

    public StatementToSQLMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        SQLAndTypeRecord rec;
        boolean debugEnabled;
        Object statement = data.getInvocationReturnValueAsObject();
        if (statement == null) {
            return;
        }
        if (!(statement instanceof Statement)) {
            Assertion.wilyAssert((String)"Expected a Statement");
            return;
        }
        if (data.getInvocationParameterCount() == 0) {
            Assertion.wilyAssert((String)"No parameters are available");
            return;
        }
        Object sql = data.getInvocationParameterAsObject(this.sqlParameterIndex);
        String rawSQL = "null";
        if (sql != null) {
            rawSQL = sql.toString();
        }
        if (debugEnabled = fFeedback.isDebugEnabled(module)) {
            String message = "received finish trace call for prepared/callable statement: %s (type %s) --> %s";
            fFeedback.debug(module, String.format(message, String.valueOf(statement), statement.getClass().getName(), String.valueOf(rawSQL)));
        }
        if ((rec = this.evaluateRawSql(statement, rawSQL)) != null) {
            try {
                concPrepNCallableStmtToSQL.putWeak(statement, (Object)rec);
                if (debugEnabled) {
                    String message = "cache - saving prepared/callable statement to sql record mapping: %s (type %s) --> %s";
                    fFeedback.debug(module, String.format(message, String.valueOf(statement), statement.getClass().getName(), String.valueOf(rec)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private SQLAndTypeRecord evaluateRawSql(Object statement, String rawSQL) {
        String normalizedSqlForMetricName = this.normalizeForMetricName(rawSQL);
        if (normalizedSqlForMetricName == null) {
            Assertion.wilyAssert((String)"Normalization didn't work");
            return null;
        }
        String normalizedSqlForUserView = this.normalizeForUserView(rawSQL, normalizedSqlForMetricName);
        if (normalizedSqlForUserView == null) {
            Assertion.wilyAssert((String)"Normalization didn't work");
            return null;
        }
        String sqlType = (String)sStatementTypeMap.get(this.getProbeIdentification().getProbeMethodName());
        if (sqlType == null) {
            Assertion.wilyAssert((String)"Couldn't figure out SQL statement type");
            return null;
        }
        String rawSQLinMap = null;
        try {
            if (fConfiguration.shouldIncludeRawSQL()) {
                rawSQLinMap = rawSQL;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SQLAndTypeRecord(rawSQLinMap, normalizedSqlForMetricName, normalizedSqlForUserView, sqlType);
    }

    private static int getIndex(Object key) {
        return key.hashCode() & 0x1F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInStaticStatementMap(Object key, Object value) {
        WeakIdentityHashMap map;
        WeakIdentityHashMap weakIdentityHashMap = map = sStatementToSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        synchronized (weakIdentityHashMap) {
            map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInStaticRawMap(Object key, Object value) {
        WeakHashMap map = sRawToNormalizedSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        key = CanonicalObjectPool.getCanonicalString((String)((String)key));
        WeakHashMap weakHashMap = map;
        synchronized (weakHashMap) {
            map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFromStaticStatementMap(Object key) {
        WeakIdentityHashMap map;
        WeakIdentityHashMap weakIdentityHashMap = map = sStatementToSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        synchronized (weakIdentityHashMap) {
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFromStaticRawMap(Object key) {
        WeakHashMap map;
        WeakHashMap weakHashMap = map = sRawToNormalizedSQLMaps[StatementToSQLMappingTracer.getIndex(key)];
        synchronized (weakHashMap) {
            return map.get(key);
        }
    }

    public static void putMapping(Object statement, String rawSQL, String sqlForMetricName, String sqlForUserView, String sqlType) {
        SQLAndTypeRecord rec = new SQLAndTypeRecord(rawSQL, sqlForMetricName, sqlForUserView, sqlType);
        concStatementToSQL.putWeak(statement, (Object)rec);
    }

    private static WeakIdentityHashMap getThreadLocalMap() {
        return (WeakIdentityHashMap)sStatementToSQLThreadLocal.get();
    }

    private static WeakHashMap getRawToNormalizedThreadLocalMap() {
        return ((RawToNormalizedSQLThreadLocalEntry)sRawToNormalizedSQLThreadLocal.get()).getMap();
    }

    public static void putRawToNormalizedMapping(String raw, String normalized) {
        StatementToSQLMappingTracer.putInStaticRawMap(raw, normalized);
        StatementToSQLMappingTracer.getRawToNormalizedThreadLocalMap().put(raw, normalized);
    }

    public static String getRawToNormalizedMapping(String raw) {
        WeakHashMap localMap = StatementToSQLMappingTracer.getRawToNormalizedThreadLocalMap();
        String answer = (String)localMap.get(raw);
        if (answer == null && (answer = (String)StatementToSQLMappingTracer.getFromStaticRawMap(raw)) != null) {
            raw = CanonicalObjectPool.getCanonicalString((String)raw);
            localMap.put(raw, answer);
        }
        return answer;
    }

    private String normalizeForMetricName(String sql) {
        String answer = StatementNormalizer.normalizeSQL(sql, fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    private String normalizeForUserView(String sql, String normalizedForMetricName) {
        String answer = StatementNormalizer.normalizeSQLForUserView(sql, normalizedForMetricName, fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    public static String getSQL(Statement statement) {
        return StatementToSQLMappingTracer.getSQL(statement, true);
    }

    public static String getSQL(Statement statement, boolean forMetricName) {
        String result = null;
        if (statement != null) {
            Object wrapper;
            SQLAndTypeRecord record = (SQLAndTypeRecord)concStatementToSQL.getWeak((Object)statement);
            if (record == null) {
                record = (SQLAndTypeRecord)concPrepNCallableStmtToSQL.getWeak((Object)statement);
                if (fFeedback.isDebugEnabled(module)) {
                    String message = "lookup 1 - original prepared/callable statement to sql record: %s (type %s) --> %s";
                    fFeedback.debug(module, String.format(message, String.valueOf(statement), statement.getClass().getName(), String.valueOf(record)));
                }
            }
            if (record == null && (wrapper = WrappedObjectToWrapperMappingTracer.getWrapper(statement)) != null) {
                record = (SQLAndTypeRecord)concPrepNCallableStmtToSQL.getWeak(wrapper);
                if (fFeedback.isDebugEnabled(module)) {
                    String message = "lookup 2 - wrapped prepared/callable statement to sql record: %s (type %s) --> %s";
                    fFeedback.debug(module, String.format(message, String.valueOf(wrapper), wrapper.getClass().getName(), String.valueOf(record)));
                }
            }
            if (record != null) {
                result = forMetricName ? record.fSQLForMetricName : record.fSQLForUserView;
            } else {
                StatementToSQLMappingTracer.displayErrorMessage();
            }
        }
        return result;
    }

    private static void displayErrorMessage() {
        long curTime = System.currentTimeMillis();
        if (curTime - lastMessageDisplayTime > 600000L) {
            lastMessageDisplayTime = curTime;
            try {
                int cacheSize = concPrepNCallableStmtToSQL.getSize();
                int maxSize = prepNCallableStmtMaxSize * 16;
                if (cacheSize >= maxSize) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().warn(module, "Active Prepared & Callable statements that are monitored exceeded the limit due to which 'Unknown SQL' metrics may get generated. Set a higher value than " + prepNCallableStmtMaxSize + " for the hot property " + "com.wily.introscope.agent.sqlagent.PreparedAndCallableStatementCache.maxsize");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getRawSQL(Statement statement) {
        String result = null;
        if (statement != null) {
            SQLAndTypeRecord record = (SQLAndTypeRecord)concStatementToSQL.getWeak((Object)statement);
            if (record == null) {
                record = (SQLAndTypeRecord)concPrepNCallableStmtToSQL.getWeak((Object)statement);
            }
            if (record != null) {
                result = record.fRawSQL;
            } else {
                StatementToSQLMappingTracer.displayErrorMessage();
            }
        }
        return result;
    }

    public static String getSQLType(Statement statement) {
        if (statement != null) {
            SQLAndTypeRecord record = (SQLAndTypeRecord)concStatementToSQL.getWeak((Object)statement);
            if (record == null) {
                record = (SQLAndTypeRecord)concPrepNCallableStmtToSQL.getWeak((Object)statement);
            }
            if (record != null) {
                return record.fType;
            }
            StatementToSQLMappingTracer.displayErrorMessage();
        }
        return null;
    }

    public static Object getBlameKey(Statement statement) {
        if (statement != null) {
            return concStatementToBlameKey.getWeak((Object)statement);
        }
        return null;
    }

    public boolean canCacheInvocationData() {
        return true;
    }

    public boolean canCacheTracerInstances() {
        return true;
    }

    public boolean canCacheComponentNames() {
        return true;
    }

    public static void putMapping(Object shouldBeStatement, String normalizedSQLForMetricName, String normalizedSQLForUserView, String kdynamicsqlstring) {
        StatementToSQLMappingTracer.putMapping(shouldBeStatement, null, normalizedSQLForMetricName, normalizedSQLForUserView, kdynamicsqlstring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRawToNormalizeCache() {
        sNormalizerConfigCounter.next();
        for (int i = 0; i < 32; ++i) {
            WeakHashMap map;
            WeakHashMap weakHashMap = map = sRawToNormalizedSQLMaps[i];
            synchronized (weakHashMap) {
                map.clear();
                continue;
            }
        }
    }

    public static void removeStatement(Statement statement) {
        try {
            concPrepNCallableStmtToSQL.removeWeak((Object)statement);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            concStatementToSQL.removeWeak((Object)statement);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        prepNCallableStmtMaxSize = 1024;
        sStatementToSQLMaps = new WeakIdentityHashMap[32];
        sRawToNormalizedSQLMaps = new WeakHashMap[32];
        for (int i = 0; i < 32; ++i) {
            StatementToSQLMappingTracer.sStatementToSQLMaps[i] = new WeakIdentityHashMap();
            StatementToSQLMappingTracer.sRawToNormalizedSQLMaps[i] = new WeakHashMap();
        }
        sStatementTypeMap = new HashMap();
        sStatementTypeMap.put("createStatement", "Dynamic");
        sStatementTypeMap.put("prepareStatement", "Prepared");
        sStatementTypeMap.put("prepareCall", "Stored Procedures");
        sStatementTypeMap.put("allocateStatement", "Dynamic");
        sStatementTypeMap.put("allocatePreparedStatement", "Prepared");
        sStatementTypeMap.put("allocateCallableStatement", "Stored Procedures");
        sStatementTypeMap.put("clientPrepareStatement", "Prepared");
        sStatementToSQLThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new WeakIdentityHashMap();
            }
        };
        IConcurrentMapFactory factory = null;
        IGuaranteedCounter counter = null;
        try {
            factory = AgentShim.getAgent().IAgent_getConcurrentMapFactory();
            fConfiguration = SQLAgentConfiguration.getInstance(AgentShim.getAgent());
            counter = AgentShim.getAgent().IAgent_getGuaranteedCounter();
            fFeedback = AgentShim.getAgent().IAgent_getModuleFeedback();
        }
        catch (AgentNotAvailableException e) {
            factory = new IConcurrentMapFactory(){

                public Map getConcurrentMap(String name) {
                    return new HashMap();
                }

                public IAgedMap getConcurrentAgingMap(String name) {
                    return null;
                }

                public IWeakMap getConcurrentWeakMap(String name) {
                    return null;
                }

                public IWeakIdentityMap getConcurrentWeakIdentityMap(String name) {
                    return null;
                }

                public void startConcurrentMapFactory(IModuleFeedbackChannel feedback, IntervalHeartbeat beat) {
                }

                public IWeakIdentityMap getConcurrentCappedWeakIdentityMap(String kobjecttoblamekeymapname2) {
                    return null;
                }

                public Map getConcurrentCappedMap(String string) {
                    return null;
                }
            };
            counter = new IGuaranteedCounter(){

                public int next() {
                    return 0;
                }

                public int prev() {
                    return 0;
                }

                public void reset() {
                }

                public IGuaranteedCounter getNewInstance() {
                    return null;
                }

                public int peek() {
                    return 0;
                }

                public int getAndSet(int i) {
                    return 0;
                }
            };
        }
        concStatementToSQL = factory.getConcurrentCappedWeakIdentityMap("StatementToSQLMap");
        concPrepNCallableStmtToSQL = factory.getConcurrentCappedWeakIdentityMap("PrepAndCallableStmtToSQLMap");
        try {
            AgentShim.getAgent().IAgent_getConfigurationManager().add((ConfigurationProperty)new PrepAndCallableStmtCacheMaxSize(AgentShim.getAgent()), true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            prepNCallableStmtMaxSize = AgentShim.getAgent().IAgent_getIndexedProperties().getIntProperty("com.wily.introscope.agent.sqlagent.PreparedAndCallableStatementCache.maxsize", 1024);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (prepNCallableStmtMaxSize > 1024) {
            try {
                ((ICappedMap)concPrepNCallableStmtToSQL).increaseMaxSize(prepNCallableStmtMaxSize);
                AgentShim.getAgent().IAgent_getModuleFeedback().debug(module, "Successfully incremented PreparedAndCallableStatements cache size to " + prepNCallableStmtMaxSize);
            }
            catch (Exception e) {
                try {
                    AgentShim.getAgent().IAgent_getModuleFeedback().error(module, "Unable to increment PreparedAndCallableStatements cache size to " + prepNCallableStmtMaxSize);
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug(module, "Exception occured while incrementing PreparedAndCallableStatements cache", (Throwable)e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        concStatementToBlameKey = factory.getConcurrentCappedWeakIdentityMap("StatementToBlameKeyMap");
        concRawToNorm = factory.getConcurrentWeakMap("rawToNormMap");
        sNormalizerConfigCounter = counter;
        sRawToNormalizedSQLThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                WeakHashMap weakHashMap = new WeakHashMap();
                RawToNormalizedSQLThreadLocalEntry entry = new RawToNormalizedSQLThreadLocalEntry(weakHashMap);
                return entry;
            }
        };
        lastMessageDisplayTime = 0L;
    }

    private static final class SQLAndTypeRecord {
        public String fSQLForMetricName;
        public String fSQLForUserView;
        public String fType;
        public String fRawSQL;

        public SQLAndTypeRecord(String rawSQL, String sqlForMetricName, String sqlForUserView, String type) {
            this.fRawSQL = rawSQL;
            this.fSQLForMetricName = sqlForMetricName;
            this.fSQLForUserView = sqlForUserView;
            this.fType = type;
        }

        public String toString() {
            return "SQLAndTypeRecord [fSQLForMetricName=" + this.fSQLForMetricName + ", fSQLForUserView=" + this.fSQLForUserView + ", fType=" + this.fType + ", fRawSQL=" + this.fRawSQL + "]";
        }
    }

    static final class PrepAndCallableStmtCacheMaxSize
    extends IntegerConfigurationProperty {
        private final IAgent fAgent;

        public PrepAndCallableStmtCacheMaxSize(IAgent agent) {
            super("com.wily.introscope.agent.sqlagent.PreparedAndCallableStatementCache.maxsize", new Integer(1024), agent.IAgent_getModuleFeedback(), null, agent.IAgent_getStringLocalizer());
            this.fAgent = agent;
        }

        public void set(Object newValue) {
            int newSize = (Integer)newValue;
            if (newSize > prepNCallableStmtMaxSize) {
                try {
                    ((ICappedMap)concPrepNCallableStmtToSQL).increaseMaxSize(newSize);
                    this.fAgent.IAgent_getModuleFeedback().info(module, "Successfully incremented PreparedAndCallableStatements cache size to " + newValue);
                    prepNCallableStmtMaxSize = newSize;
                }
                catch (Exception e) {
                    this.fAgent.IAgent_getModuleFeedback().error(module, "Unable to increment PreparedAndCallableStatements cache size to " + newValue);
                    this.fAgent.IAgent_getModuleFeedback().debug(module, "Exception occured while incrementing PreparedAndCallableStatements cache", (Throwable)e);
                }
            }
        }
    }

    private static final class RawToNormalizedSQLThreadLocalEntry {
        private int fCurrentConfig;
        private WeakHashMap fMap;

        public RawToNormalizedSQLThreadLocalEntry(WeakHashMap weakHashMap) {
            this.fMap = weakHashMap;
            this.fCurrentConfig = sNormalizerConfigCounter.peek();
        }

        public WeakHashMap getMap() {
            int current = sNormalizerConfigCounter.peek();
            if (current != this.fCurrentConfig) {
                this.fMap.clear();
                this.fCurrentConfig = current;
            }
            return this.fMap;
        }
    }
}

