/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.beans.remoteconfiguration;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.agent.beans.remoteconfiguration.DisabledException;
import com.wily.introscope.spec.agent.beans.remoteconfiguration.DisallowedException;
import com.wily.introscope.spec.agent.beans.remoteconfiguration.IAgentRemoteConfigurationService;
import com.wily.isengard.IsengardException;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.util.IConfigurationListener;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class AgentRemoteConfigurationBean
extends AIsengardBean
implements IAgentRemoteConfigurationService {
    private static final String kRemoteAgentConfigurationEnabledKey = "introscope.agent.remoteagentconfiguration.enabled";
    private static final boolean kDefaultRemoteAgentConfigurationEnabled = true;
    private static final String kRemoteAgentConfigurationAllowedFilesKey = "introscope.agent.remoteagentconfiguration.allowedFiles";
    private static final String[] kDefaultRemoteAgentConfigurationAllowedFiles = new String[0];
    private IAgent fAgent;
    private String fAgentHost;
    private String fAgentProcess;
    private String fQualifiedAgentName;
    private INameChangeListener fChangeListener;
    private String[] fAllowedFiles;
    private volatile boolean fActive;
    private static AgentRemoteConfigurationListener sConfigListener;
    private static boolean sAgentRemoteConfigurationInitialized;

    @Override
    public void activate() throws IsengardException {
        this.fAgent = (IAgent)this.getBeanDescriptor().getInstanceData();
        boolean enabled = this.fAgent.IAgent_getIndexedProperties().safeGetBooleanProperty(kRemoteAgentConfigurationEnabledKey, true, this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer());
        this.fAllowedFiles = this.fAgent.IAgent_getIndexedProperties().safeGetSeparatedProperty(kRemoteAgentConfigurationAllowedFilesKey, ",", kDefaultRemoteAgentConfigurationAllowedFiles);
        String[] hostProcessAgent = this.fAgent.IAgent_getHostProcessAgentTriplet();
        this.fAgentHost = hostProcessAgent[0];
        this.fAgentProcess = hostProcessAgent[1];
        this.fActive = true;
        if (!enabled) {
            this.fActive = false;
        }
        this.fChangeListener = new INameChangeListener(){

            @Override
            public void INameChangeListener_nameChanged(String newName) {
                try {
                    if (AgentRemoteConfigurationBean.this.fQualifiedAgentName != null) {
                        AgentRemoteConfigurationBean.this.destroyMessageService(IAgentRemoteConfigurationService.class, AgentRemoteConfigurationBean.this.fQualifiedAgentName);
                    }
                    AgentRemoteConfigurationBean.this.fQualifiedAgentName = AgentRemoteConfigurationBean.this.fAgentHost + "|" + AgentRemoteConfigurationBean.this.fAgentProcess + "|" + newName;
                    if (AgentRemoteConfigurationBean.this.fAgent.IAgent_getModuleFeedback().isVerboseEnabled()) {
                        AgentRemoteConfigurationBean.this.fAgent.IAgent_getModuleFeedback().verbose("Registering RemoteConfigurationService for new agent name : " + AgentRemoteConfigurationBean.this.fQualifiedAgentName);
                    }
                    AgentRemoteConfigurationBean.this.createMessageService(IAgentRemoteConfigurationService.class, AgentRemoteConfigurationBean.this.fQualifiedAgentName, new String[]{"Workstation", "Server"});
                }
                catch (Exception e) {
                    AgentRemoteConfigurationBean.this.fAgent.IAgent_getModuleFeedback().error(AgentRemoteConfigurationBean.this.fAgent.IAgent_getModule(), "Failed to re-register IAgentRemoteConfigurationService on Agent name change event.");
                    AgentRemoteConfigurationBean.this.fAgent.IAgent_getModuleFeedback().debug(AgentRemoteConfigurationBean.this.fAgent.IAgent_getModule(), "Failed to re-register IAgentRemoteConfigurationService on Agent name change event.", e);
                    AgentRemoteConfigurationBean.this.fQualifiedAgentName = null;
                }
            }
        };
        this.fAgent.IAgent_addNegotiatedNameChangeListener(this.fChangeListener);
        this.addRemoteAgentListener();
    }

    @Override
    public void passivate() {
        if (this.fChangeListener != null) {
            this.fAgent.IAgent_removeNegotiatedNameChangeListener(this.fChangeListener);
        }
        this.fActive = false;
        this.removeRemoteAgentListener(sConfigListener);
        super.passivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllowed(String fileName) {
        String[] allowedFiles;
        AgentRemoteConfigurationBean agentRemoteConfigurationBean = this;
        synchronized (agentRemoteConfigurationBean) {
            allowedFiles = (String[])this.fAllowedFiles.clone();
        }
        for (int i = 0; i < allowedFiles.length; ++i) {
            if (!fileName.trim().equalsIgnoreCase(allowedFiles[i].trim())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAllowedList() {
        String[] allowedFiles;
        AgentRemoteConfigurationBean agentRemoteConfigurationBean = this;
        synchronized (agentRemoteConfigurationBean) {
            allowedFiles = (String[])this.fAllowedFiles.clone();
        }
        String s = "";
        for (int i = 0; i < allowedFiles.length; ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + allowedFiles[i].trim();
        }
        return s;
    }

    private boolean checkForAllowedRelativeDestinationDir(String agentRootDirStr, String destinationFileStr) throws IOException {
        File parentDir;
        File agentRootDir = new File(agentRootDirStr).getCanonicalFile();
        File destinationFile = new File(destinationFileStr).getCanonicalFile();
        for (parentDir = destinationFile.getParentFile(); parentDir != null && !parentDir.equals(agentRootDir); parentDir = parentDir.getParentFile()) {
        }
        return parentDir != null;
    }

    private boolean isActive() {
        return this.fActive;
    }

    private boolean isAllowedAndActive(String filename) throws IOException {
        if (!this.isActive()) {
            this.fAgent.IAgent_getModuleFeedback().info("Failed to write to configuration file ... property introscope.agent.remoteagentconfiguration.enabled not enabled");
            throw new DisabledException("Failed to write to configuration file ... property introscope.agent.remoteagentconfiguration.enabled not enabled");
        }
        if (!this.isAllowed(filename)) {
            throw new DisallowedException("This agent only allows remote transfer of following files: " + this.getAllowedList());
        }
        return true;
    }

    @Override
    public void sendConfigurationFile(String fileName, String relativeDestinationDir, byte[] fileData) throws IOException {
        this.isAllowedAndActive(fileName);
        String agentConfigRootDir = new File(this.fAgent.IAgent_getConfigurationResource().IResource_getLocation()).getParent();
        String destinationFileName = agentConfigRootDir + (relativeDestinationDir != null ? File.separator + relativeDestinationDir : "") + File.separator + fileName;
        if (!this.checkForAllowedRelativeDestinationDir(agentConfigRootDir, destinationFileName)) {
            throw new IOException("You can write a file only to the Introscope Agent's root directory or its subdirectories.");
        }
        if (fileData == null) {
            this.fAgent.IAgent_getModuleFeedback().info("Configuration file " + destinationFileName + " cannot be written. Data is corrupt or missing");
            throw new IOException("Configuration file " + destinationFileName + " cannot be written. Data is corrupt or missing");
        }
        try {
            this.fAgent.IAgent_getModuleFeedback().info("Writing configuration file " + destinationFileName + " ...");
            if (!new File(new File(destinationFileName).getParent()).exists()) {
                new File(new File(destinationFileName).getParent()).mkdir();
            }
            FileOutputStream fileOut = new FileOutputStream(destinationFileName);
            fileOut.write(fileData);
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException ioe) {
            this.fAgent.IAgent_getModuleFeedback().error("Error while writing configuration file " + destinationFileName, ioe);
            throw ioe;
        }
        this.fAgent.IAgent_getModuleFeedback().info("Configuration file " + destinationFileName + " written successfully.");
    }

    public boolean isRemoteAgentConfigurationEnabled(IndexedProperties newProps) {
        boolean enabled = newProps.getBooleanProperty(kRemoteAgentConfigurationEnabledKey, true);
        return enabled;
    }

    public void addRemoteAgentListener() {
        if (!sAgentRemoteConfigurationInitialized) {
            sAgentRemoteConfigurationInitialized = true;
            sConfigListener = new AgentRemoteConfigurationListener(this.fAgent.IAgent_getModuleFeedback(), this);
            this.fAgent.addConfigurationListener(sConfigListener);
        }
    }

    private void removeRemoteAgentListener(AgentRemoteConfigurationListener listener) {
        this.fAgent.removeConfigurationListener(listener);
        sAgentRemoteConfigurationInitialized = false;
    }

    static /* synthetic */ String[] access$802(AgentRemoteConfigurationBean x0, String[] x1) {
        x0.fAllowedFiles = x1;
        return x1;
    }

    private static class AgentRemoteConfigurationListener
    implements IConfigurationListener {
        private IModuleFeedbackChannel feedback;
        private AgentRemoteConfigurationBean parent;

        private AgentRemoteConfigurationListener(IModuleFeedbackChannel feedback, AgentRemoteConfigurationBean parent) {
            this.feedback = feedback;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(IndexedProperties newProps) {
            Object[] allowedFiles = newProps.safeGetSeparatedProperty(AgentRemoteConfigurationBean.kRemoteAgentConfigurationAllowedFilesKey, ",", kDefaultRemoteAgentConfigurationAllowedFiles);
            if (!Arrays.equals(this.parent.fAllowedFiles, allowedFiles)) {
                AgentRemoteConfigurationListener agentRemoteConfigurationListener = this;
                synchronized (agentRemoteConfigurationListener) {
                    AgentRemoteConfigurationBean.access$802(this.parent, (String[])allowedFiles);
                    this.parent.fAgent.IAgent_getModuleFeedback().info("AgentRemoteConfiguration: allowed files list has been updated");
                }
            }
            if (this.parent.fActive != this.parent.isRemoteAgentConfigurationEnabled(newProps)) {
                this.parent.fActive = this.parent.isRemoteAgentConfigurationEnabled(newProps);
                if (this.parent.fActive) {
                    this.parent.fAgent.IAgent_getModuleFeedback().info("AgentRemoteConfiguration has been enabled");
                } else {
                    this.parent.fAgent.IAgent_getModuleFeedback().info("AgentRemoteConfiguration has been disabled");
                }
            }
        }
    }
}

