/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.util.WilyStringBuilder;
import java.lang.reflect.Array;

public class UnsignedByteArray {
    private static final FieldFormatter decimalFormatter = new FieldFormatter(){

        @Override
        public String toString(int i) {
            return Integer.toString(i);
        }
    };
    private static final FieldFormatter hexFormatter = new FieldFormatter(){

        @Override
        public String toString(int i) {
            return Integer.toHexString(i);
        }
    };
    private final byte[] bytes;

    public UnsignedByteArray(byte[] bytes) {
        this.bytes = bytes == null ? new byte[]{} : bytes;
    }

    public UnsignedByteArray(String str, int length, int bytesPerField, int maxFieldWidth, String separator, boolean isDecimal) throws IllegalArgumentException, NumberFormatException {
        if (length < 0 || bytesPerField < 0 || bytesPerField > 4 || maxFieldWidth < 1 || length % bytesPerField > 0 || str == null || separator == null || separator.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.bytes = new byte[length];
        int maxFields = length / bytesPerField;
        int maxValue = -1 >>> (4 - bytesPerField) * 8;
        int byteStart = 0;
        int fieldStart = 0;
        int fieldEnd = 0;
        int separatorLength = separator.length();
        boolean done = false;
        for (int nField = 0; nField < maxFields && !done; ++nField) {
            fieldEnd = str.indexOf(separator, fieldStart);
            if (nField > 0 && fieldEnd == fieldStart) {
                int nextSepStart;
                int sepStart = fieldStart + separator.length();
                int strlen = str.length();
                int remainingSeparators = 0;
                while (sepStart < strlen && (nextSepStart = str.indexOf(separator, sepStart)) >= 0) {
                    ++remainingSeparators;
                    sepStart = nextSepStart + separatorLength;
                }
                int skippedFields = maxFields - nField - 1 - remainingSeparators;
                if (skippedFields < 1) {
                    throw new IllegalArgumentException();
                }
                byteStart += skippedFields * bytesPerField;
                fieldEnd = fieldStart;
            } else {
                int fieldInt;
                String field;
                int fieldLength;
                boolean bl = done = fieldEnd < 0;
                if (done) {
                    fieldEnd = str.length();
                }
                if ((fieldLength = (field = str.substring(fieldStart, fieldEnd)).length()) > maxFieldWidth) {
                    throw new IllegalArgumentException();
                }
                int n = fieldLength == 0 ? 0 : (fieldInt = Integer.parseInt(field, isDecimal ? 10 : 16));
                if (fieldInt > maxValue) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < bytesPerField; ++i) {
                    this.bytes[byteStart + (bytesPerField - i) - 1] = (byte)(fieldInt >> i * 8 & 0xFFFFFFFF);
                }
                byteStart += bytesPerField;
            }
            fieldStart = fieldEnd + separatorLength;
        }
        if (!done) {
            throw new IllegalArgumentException();
        }
    }

    public UnsignedByteArray(int length, int nLeadingOnes) throws IllegalArgumentException {
        if (length < 0 || nLeadingOnes < 0 || nLeadingOnes > length * 8) {
            throw new IllegalArgumentException();
        }
        this.bytes = new byte[length];
        int nAllLeadingOnesBytes = nLeadingOnes / 8;
        for (int i = 0; i < nAllLeadingOnesBytes; ++i) {
            this.bytes[i] = -1;
        }
        int nRemainingLeadingOnes = nLeadingOnes % 8;
        if (nRemainingLeadingOnes > 0) {
            this.bytes[nAllLeadingOnesBytes] = (byte)(-1 << 8 - nRemainingLeadingOnes);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public UnsignedByteArray and(UnsignedByteArray other) {
        byte[] otherBytes = other != null ? other.getBytes() : new byte[]{};
        byte[] result = (byte[])Array.newInstance(Byte.TYPE, this.bytes.length);
        int shortestLength = Math.min(this.bytes.length, otherBytes.length);
        for (int i = 0; i < shortestLength; ++i) {
            result[i] = (byte)(this.bytes[i] & otherBytes[i]);
        }
        return new UnsignedByteArray(result);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        byte[] otherBytes = ((UnsignedByteArray)other).getBytes();
        if (this.bytes.length != otherBytes.length) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == otherBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            result = result * 31 ^ this.bytes[i];
        }
        return result;
    }

    public String format(int bytesPerField, int minFieldOutputWidth, String separator, boolean formatAsDecimal, boolean toUpper) {
        FieldFormatter fieldFormatter = formatAsDecimal ? decimalFormatter : hexFormatter;
        WilyStringBuilder sb = new WilyStringBuilder();
        String sep = "";
        for (int i = 0; i < this.bytes.length; i += bytesPerField) {
            int ipField = 0;
            for (int j = 0; j < bytesPerField; ++j) {
                ipField <<= 8;
                int unsignedByte = this.bytes[i + j];
                ipField += (unsignedByte &= 0xFF);
            }
            sb.append(sep);
            String fieldStr = fieldFormatter.toString(ipField);
            int paddingWidth = Math.max(0, minFieldOutputWidth - fieldStr.length());
            for (int j = 0; j < paddingWidth; ++j) {
                sb.append("0");
            }
            sb.append(!formatAsDecimal && toUpper ? fieldStr.toUpperCase() : fieldStr);
            sep = separator;
        }
        return sb.toString();
    }

    public String toString() {
        return this.format(1, 2, " ", false, true);
    }

    private static interface FieldFormatter {
        public String toString(int var1);
    }
}

