/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.KMetricNameConstants;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.util.StringUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;

public class AddressHostNameHelper {
    public static final String getHostName(InetSocketAddress addr) {
        String host = null;
        try {
            String ipAddress;
            InetAddress localhost;
            if (addr == null) {
                return "Unknown Host";
            }
            IAgent agent = null;
            IDnsService dnsService = null;
            try {
                agent = AgentShim.getAgent();
                host = agent != null ? ((dnsService = agent.IAgent_getDnsService()) != null ? dnsService.getDnsHostNameByIPAddr(addr.getAddress()) : addr.getHostName()) : addr.getHostName();
            }
            catch (AgentNotAvailableException ex) {
                host = addr.getHostName();
            }
            catch (TimeoutException exTimeout) {
                host = addr.getAddress().getHostAddress();
            }
            if (host != null && host.length() > 0 && (host.equals("0.0.0.0") || host.equals("0.0.0.0.0.0")) && (localhost = InetAddress.getLocalHost()) != null) {
                host = dnsService != null ? dnsService.getDnsHostNameByIPAddr(localhost) : localhost.getHostName();
            }
            if ((host == null || host.length() == 0) && (ipAddress = addr.getAddress().getHostAddress()) != null) {
                host = ipAddress;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleDebug("ManagedSocket com_wily_safeGetNameFromInetAddress", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (host == null || host.length() == 0) {
            host = "Unknown Host";
        }
        host = StringUtils.replaceIllegalChars(host, KMetricNameConstants.kIllegalResourceChars, '_');
        return host;
    }

    public static final String getHostNameForInetAddress(InetAddress addr) {
        String host = null;
        try {
            String ipAddress;
            InetAddress localhost;
            if (addr == null) {
                return "Unknown Host";
            }
            IAgent agent = null;
            IDnsService dnsService = null;
            try {
                agent = AgentShim.getAgent();
                host = agent != null ? ((dnsService = agent.IAgent_getDnsService()) != null ? dnsService.getDnsHostNameByIPAddr(addr) : addr.getHostName()) : addr.getHostName();
            }
            catch (AgentNotAvailableException ex) {
                host = addr.getHostName();
            }
            catch (TimeoutException exTimeout) {
                host = addr.getHostAddress();
            }
            if (host != null && host.length() > 0 && (host.equals("0.0.0.0") || host.equals("0.0.0.0.0.0")) && (localhost = InetAddress.getLocalHost()) != null) {
                host = dnsService != null ? dnsService.getDnsHostNameByIPAddr(localhost) : localhost.getHostName();
            }
            if ((host == null || host.length() == 0) && (ipAddress = addr.getHostAddress()) != null) {
                host = ipAddress;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleDebug("ManagedSocket com_wily_safeGetNameFromInetAddress", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (host == null || host.length() == 0) {
            host = "Unknown Host";
        }
        host = StringUtils.replaceIllegalChars(host, KMetricNameConstants.kIllegalResourceChars, '_');
        return host;
    }
}

