/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.parameter;

import com.wily.introscope.agent.trace.parameter.Parameter;
import com.wily.util.StringUtils;

public abstract class CoreParameters {
    private CoreParameters() {
    }

    public static String replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(String s) {
        return StringUtils.removeTrailingSpaces(s.replace(':', '_').replace('|', '_'));
    }

    public static final class ObjectParameter
    extends Parameter {
        private Object fValue;

        @Override
        public void setValue(Object value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(Object value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "object";
        }

        @Override
        public Object toObject() {
            return this.fValue;
        }

        @Override
        public String toString() {
            try {
                return CoreParameters.replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(this.fValue.toString());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                return "unable to get toString value";
            }
        }

        @Override
        public void reset() {
            this.fValue = null;
        }
    }

    public static final class CharParameter
    extends Parameter {
        private char fValue;

        @Override
        public void setValue(char value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(char value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "char";
        }

        @Override
        public Object toObject() {
            return Character.valueOf(this.fValue);
        }

        @Override
        public String toString() {
            return CoreParameters.replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(String.valueOf(this.fValue));
        }

        @Override
        public void reset() {
            this.fValue = '\u0000';
        }
    }

    public static final class BooleanParameter
    extends Parameter {
        private boolean fValue;

        @Override
        public void setValue(boolean value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(boolean value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "boolean";
        }

        @Override
        public Object toObject() {
            return this.fValue ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public String toString() {
            return String.valueOf(this.fValue);
        }

        @Override
        public void reset() {
            this.fValue = false;
        }
    }

    public static final class DoubleParameter
    extends Parameter {
        private double fValue;

        @Override
        public void setValue(double value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(double value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "double";
        }

        @Override
        public Object toObject() {
            return this.fValue;
        }

        @Override
        public String toString() {
            return String.valueOf(this.fValue);
        }

        @Override
        public void reset() {
            this.fValue = 0.0;
        }
    }

    public static final class FloatParameter
    extends Parameter {
        private float fValue;

        @Override
        public void setValue(float value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(float value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "float";
        }

        @Override
        public Object toObject() {
            return Float.valueOf(this.fValue);
        }

        @Override
        public String toString() {
            return String.valueOf(this.fValue);
        }

        @Override
        public void reset() {
            this.fValue = 0.0f;
        }
    }

    public static final class SInt64Parameter
    extends Parameter {
        private long fValue;

        @Override
        public void setValue(long value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(long value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "SInt64";
        }

        @Override
        public Object toObject() {
            return this.fValue;
        }

        @Override
        public String toString() {
            return String.valueOf(this.fValue);
        }

        @Override
        public void reset() {
            this.fValue = 0L;
        }
    }

    public static final class SInt32Parameter
    extends Parameter {
        private int fValue;

        @Override
        public void setValue(int value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(int value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "SInt32";
        }

        @Override
        public Object toObject() {
            return this.fValue;
        }

        @Override
        public String toString() {
            return String.valueOf(this.fValue);
        }

        @Override
        public void reset() {
            this.fValue = 0;
        }
    }

    public static final class SInt16Parameter
    extends Parameter {
        private short fValue;

        @Override
        public void setValue(short value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(short value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "SInt16";
        }

        @Override
        public Object toObject() {
            return this.fValue;
        }

        @Override
        public String toString() {
            return String.valueOf(this.fValue);
        }

        @Override
        public void reset() {
            this.fValue = 0;
        }
    }

    public static final class SInt8Parameter
    extends Parameter {
        private byte fValue;

        @Override
        public void setValue(byte value) {
            this.fValue = value;
        }

        @Override
        public boolean isExpectedType(byte value) {
            return true;
        }

        @Override
        public String getExpectedType() {
            return "SInt8";
        }

        @Override
        public Object toObject() {
            return this.fValue;
        }

        @Override
        public String toString() {
            return CoreParameters.replacePipesColonsWithUnderscoreAndRemoveTrailingSpaces(String.valueOf(this.fValue));
        }

        @Override
        public void reset() {
            this.fValue = 0;
        }
    }
}

