/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.transactiontrace.ABaseCorrelationId;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.ICorrelationIdProvider;
import com.wily.introscope.agent.transactiontrace.ICorrelationParameterConsumer;
import com.wily.introscope.agent.transactiontrace.ICorrelationParameterProvider;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CorrelationService {
    private List<ICorrelationIdProvider> idProviders = new CopyOnWriteArrayList<ICorrelationIdProvider>();
    private static final CorrelationService instance = new CorrelationService();

    private CorrelationService() {
        this.addCorrelationIdProvider(new WilyCorrelationIdProvider());
    }

    public static CorrelationService getInstance() {
        return instance;
    }

    public void addCorrelationIdProvider(ICorrelationIdProvider p) {
        this.idProviders.add(p);
    }

    public void removeCorrelationIdProvider(ICorrelationIdProvider p) {
        this.idProviders.remove(p);
    }

    public void putCorrelationId(ICorrelationParameterConsumer paramConsumer) {
        for (ICorrelationIdProvider provider : this.idProviders) {
            provider.putCorrelationId(paramConsumer);
        }
    }

    public ABaseCorrelationId getCorrelationId(InvocationData data, ICorrelationParameterProvider paramProvider, boolean override) {
        data.ensureCrossProcessCache();
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        if (cache.hasRemotelyGeneratedCorrelationId()) {
            return new CorrelationId(cache);
        }
        for (ICorrelationIdProvider provider : this.idProviders) {
            ABaseCorrelationId result = provider.getCorrelationId(paramProvider, override);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String makeCorGuid(long corIdHigh, long corIdLow) {
        return CorrelationService.makeCorGuid(Long.toHexString(corIdHigh), Long.toHexString(corIdLow));
    }

    public static String makeCorGuid(String corIdHigh, String corIdLow) {
        int i;
        StringBuilder result = new StringBuilder(32);
        if (corIdHigh != null) {
            int padding1 = 16 - corIdHigh.length();
            for (i = 0; i < padding1; ++i) {
                result.append('0');
            }
            result.append(corIdHigh);
        }
        int padding2 = 16 - corIdLow.length();
        for (i = 0; i < padding2; ++i) {
            result.append('0');
        }
        result.append(corIdLow);
        return result.toString().toUpperCase();
    }

    public static String makeComponentId(long id) {
        return CorrelationService.makeComponentId(Long.toHexString(id));
    }

    public static String makeComponentId(String id) {
        StringBuilder result = new StringBuilder(16);
        int padding1 = 16 - id.length();
        for (int i = 0; i < padding1; ++i) {
            result.append('0');
        }
        result.append(id);
        return result.toString().toUpperCase();
    }

    public static long getCorIdHigh(String corGuid) {
        String hexString;
        int len = corGuid.length();
        if (len < 16) {
            return 0L;
        }
        if (len > 32) {
            corGuid = corGuid.substring(len - 32);
            len = 32;
        }
        if ((hexString = corGuid.substring(0, len - 16)).isEmpty()) {
            return 0L;
        }
        long result = new BigInteger(hexString, 16).longValue();
        return result;
    }

    public static long getCorIdLow(String corGuid) {
        String hexString = corGuid;
        int len = corGuid.length();
        int start = len - 16;
        if (start > 0) {
            hexString = corGuid.substring(start);
        }
        long result = new BigInteger(hexString, 16).longValue();
        return result;
    }

    private static class WilyCorrelationIdProvider
    implements ICorrelationIdProvider {
        private WilyCorrelationIdProvider() {
        }

        @Override
        public ABaseCorrelationId getCorrelationId(ICorrelationParameterProvider provider, boolean override) {
            String corIdString = provider.getCorrelationParameter("CorID");
            if (corIdString == null) {
                corIdString = provider.getCorrelationParameter("x-wily-guid");
            }
            if (corIdString != null) {
                return new CorrelationId(corIdString, override);
            }
            return null;
        }

        @Override
        public void putCorrelationId(ICorrelationParameterConsumer consumer) {
            if (consumer.isCorrelationParamterSet("CorID")) {
                return;
            }
            CorrelationId result = new CorrelationId();
            String correlationString = result.getOutgoingCorrelationIdStrippedForHeader();
            consumer.putCorrelationParameter("CorID", correlationString);
        }
    }
}

