/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback.backend;

import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.SystemOutFeedbackChannel;
import com.wily.util.feedback.backend.IFeedbackBackend;
import com.wily.util.feedback.backend.NativeFeedbackBackendFactory;
import com.wily.util.feedback.backend.PropertyConfigurableBackend;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class SystemOutBackend
extends PropertyConfigurableBackend
implements NativeFeedbackBackendFactory {
    private static final SystemOutBackend instance = new SystemOutBackend();
    private final ConcurrentMap<String, SystemOutFeedbackChannel> loggers = new ConcurrentHashMap<String, SystemOutFeedbackChannel>();
    private final AtomicReference<List<Map.Entry<String, SeverityLevel>>> config = new AtomicReference();

    private SystemOutBackend() {
    }

    public static NativeFeedbackBackendFactory getInstance() {
        return instance;
    }

    @Override
    public IFeedbackBackend getNativeFeedbackBackend() {
        return instance;
    }

    @Override
    public Object getLoggerByName(String name) {
        SystemOutFeedbackChannel logger = (SystemOutFeedbackChannel)this.loggers.get(name);
        if (logger == null) {
            SeverityLevel level;
            logger = new SystemOutFeedbackChannel(name);
            SystemOutFeedbackChannel existing = this.loggers.putIfAbsent(name, logger);
            if (existing != null) {
                logger = existing;
            }
            if ((level = this.getEffectiveLevelForLogger(name)) != null) {
                logger.setLevel(level, null);
            }
        }
        return logger;
    }

    private SeverityLevel getEffectiveLevelForLogger(String name) {
        List<Map.Entry<String, SeverityLevel>> currentConfig = this.config.get();
        if (currentConfig == null) {
            return this.rootLevel;
        }
        int i = 0;
        while (i < currentConfig.size()) {
            Map.Entry<String, SeverityLevel> entry = currentConfig.get(i);
            if (name.startsWith(entry.getKey())) {
                return entry.getValue();
            }
            ++i;
        }
        return this.rootLevel;
    }

    @Override
    public void configureFromProperties(Properties properties) {
        Object level;
        Enumeration<?> e = properties.propertyNames();
        ArrayList<ConfigEntry> levelProps = new ArrayList<ConfigEntry>();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (!attribute.startsWith(levelPropertyPrefix)) continue;
            String name = attribute.substring(levelPropertyPrefix.length());
            name = name.trim();
            level = properties.getProperty(attribute);
            level = ((String)level).trim().toUpperCase();
            SeverityLevel l = SeverityLevel.getLevelByName((String)level);
            if (name.equals("root")) {
                this.setRootLevel(l);
            } else {
                levelProps.add(new ConfigEntry(name, l));
            }
            SystemOutFeedbackChannel logger = (SystemOutFeedbackChannel)this.loggers.get(name);
            if (logger == null) continue;
            logger.setLevel(l, null);
        }
        Collections.sort(levelProps, new Comparator<Map.Entry<String, SeverityLevel>>(){

            @Override
            public int compare(Map.Entry<String, SeverityLevel> e1, Map.Entry<String, SeverityLevel> e2) {
                return e2.getKey().length() - e1.getKey().length();
            }
        });
        this.config.set(levelProps);
        for (String loggerName : this.loggers.keySet()) {
            level = this.getEffectiveLevelForLogger(loggerName);
            ((SystemOutFeedbackChannel)this.loggers.get(loggerName)).setLevel((SeverityLevel)level, null);
        }
    }

    private SystemOutFeedbackChannel getLogger(Object obj) {
        return (SystemOutFeedbackChannel)obj;
    }

    @Override
    public void log(Object logger, SeverityLevel level, Object message, Throwable t) {
        this.getLogger(logger).log(level, (String)message, t);
    }

    @Override
    public SeverityLevel getEffectiveLevel(Object logger) {
        return this.getLogger(logger).getEffectiveLevel(null);
    }

    @Override
    public SeverityLevel getLevel(Object logger) {
        return this.getLogger(logger).getLevel(null);
    }

    @Override
    public void setLevel(Object logger, SeverityLevel level) {
        this.getLogger(logger).setLevel(level, null);
    }

    @Override
    public boolean isEnabledFor(Object logger, SeverityLevel level) {
        SeverityLevel currentLevel = this.getLevel(logger);
        return !currentLevel.isLessThan(level);
    }

    @Override
    public String getName(Object logger) {
        return this.getLogger(logger).getModuleName();
    }

    private static class ConfigEntry
    implements Map.Entry<String, SeverityLevel> {
        String key;
        SeverityLevel value;

        ConfigEntry(String key, SeverityLevel value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public SeverityLevel getValue() {
            return this.value;
        }

        @Override
        public SeverityLevel setValue(SeverityLevel value) {
            this.value = value;
            return this.value;
        }
    }
}

